/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.model;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.client.BlockSkinRenderHelper;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.util.ItemHelper;

public class SmelteryRender
implements ISimpleBlockRenderingHandler {
    public static int smelteryModel = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == smelteryModel) {
            ItemHelper.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == smelteryModel) {
            if (world.func_72805_g(x, y, z) == 0) {
                return this.renderSmeltery(world, x, y, z, block, modelID, renderer);
            }
            renderer.func_147784_q(block, x, y, z);
        }
        return true;
    }

    public boolean renderSmeltery(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        renderer.func_147784_q(block, x, y, z);
        SmelteryLogic logic = (SmelteryLogic)world.func_147438_o(x, y, z);
        if (logic.validStructure) {
            CoordTuple from = logic.minPos;
            CoordTuple to = logic.maxPos;
            if (logic.func_70302_i_() > 0) {
                for (int i = 0; i < logic.layers; ++i) {
                    this.renderLayer(logic, i * logic.getBlocksPerLayer(), from, to, from.y + i, renderer, world);
                }
            }
            float base = 0.0f;
            int yBase = 0;
            int liquidBase = 0;
            for (FluidStack liquid : logic.moltenMetal) {
                int liquidSize = liquid.amount;
                while (liquidSize > 0) {
                    int cap = logic.getCapacityPerLayer();
                    int room = cap - liquidBase;
                    int countSize = liquidSize > room ? room : liquidSize;
                    liquidSize -= countSize;
                    float height = countSize > cap ? 1.0f : (float)countSize / (float)cap;
                    float renderBase = base;
                    float renderHeight = height + base;
                    base += height;
                    liquidBase += countSize;
                    if ((double)renderHeight < 0.01) {
                        renderHeight = 0.01f;
                    }
                    renderer.func_147782_a(0.0, (double)renderBase, 0.0, 1.0, (double)renderHeight, 1.0);
                    Fluid fluid = liquid.getFluid();
                    for (int xi = from.x; xi <= to.x; ++xi) {
                        for (int zi = from.z; zi <= to.z; ++zi) {
                            float minX = xi == from.x ? -0.001f : 0.0f;
                            float minZ = zi == from.z ? -0.001f : 0.0f;
                            float maxX = xi == to.x ? 1.001f : 1.0f;
                            float maxZ = zi == to.z ? 1.001f : 1.0f;
                            renderer.func_147782_a((double)minX, (double)renderBase, (double)minZ, (double)maxX, (double)renderHeight, (double)maxZ);
                            if (fluid.canBePlacedInWorld()) {
                                BlockSkinRenderHelper.renderMetadataBlock(fluid.getBlock(), 0, xi, from.y + yBase, zi, renderer, world);
                                continue;
                            }
                            BlockSkinRenderHelper.renderLiquidBlock(fluid.getStillIcon(), fluid.getFlowingIcon(), xi, from.y + yBase, zi, renderer, world, false, fluid.getColor(liquid));
                        }
                    }
                    if (countSize != room) continue;
                    base = 0.0f;
                    ++yBase;
                    liquidBase = 0;
                }
            }
        }
        return true;
    }

    void renderLayer(SmelteryLogic logic, int start, CoordTuple from, CoordTuple to, int posY, RenderBlocks renderer, IBlockAccess world) {
        renderer.func_147782_a((double)-0.001f, (double)-0.001f, (double)-0.001f, (double)1.001f, (double)1.001f, (double)1.001f);
        int i = start;
        for (int x = from.x; x <= to.x; ++x) {
            for (int z = from.z; z <= to.z; ++z) {
                ItemStack blockToRender;
                if (i > logic.func_70302_i_()) {
                    return;
                }
                ItemStack input = logic.func_70301_a(i);
                if (input != null && logic.getTempForSlot(i) > 20 && (blockToRender = Smeltery.getRenderIndex(input)) != null) {
                    float blockHeight = (float)input.field_77994_a / (float)blockToRender.field_77994_a;
                    renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)MathHelper.func_76131_a((float)blockHeight, (float)0.01f, (float)1.0f), 1.0);
                    Block liquidBlock = Block.func_149634_a((Item)blockToRender.func_77973_b());
                    BlockSkinRenderHelper.renderMetadataBlock(liquidBlock, blockToRender.func_77960_j(), x, posY, z, renderer, world);
                }
                ++i;
            }
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return smelteryModel;
    }
}

