/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.library.util.TextureHelper;
import tconstruct.util.config.PHConstruct;

public class DynamicToolPart
extends CraftingItem
implements IToolPart {
    public String partName;
    public String texture;
    public IIcon defaultIcon;
    private boolean hidden = false;

    public DynamicToolPart(String texture, String name) {
        this(texture, name, "tinker");
    }

    public DynamicToolPart(String texture, String name, String domain) {
        super(null, null, "parts/", domain, (CreativeTabs)TConstructRegistry.partTab);
        this.func_77655_b("tconstruct." + name);
        this.partName = name;
        this.texture = texture;
    }

    public DynamicToolPart hide() {
        this.hidden = true;
        return this;
    }

    @Override
    public int getMaterialID(ItemStack stack) {
        if (TConstructRegistry.toolMaterials.keySet().contains(stack.func_77960_j())) {
            return stack.func_77960_j();
        }
        return -1;
    }

    public String func_77653_i(ItemStack stack) {
        ToolMaterial toolmat = TConstructRegistry.getMaterial(this.getMaterialID(stack));
        if (toolmat == null) {
            return super.func_77653_i(stack);
        }
        String material = toolmat.localizationString.substring(9);
        if (StatCollector.func_94522_b((String)("toolpart." + this.partName + "." + material))) {
            return StatCollector.func_74838_a((String)("toolpart." + this.partName + "." + material));
        }
        String matName = StatCollector.func_94522_b((String)("toolpart.material." + material)) ? StatCollector.func_74838_a((String)("toolpart.material." + material)) : toolmat.prefixName();
        return StatCollector.func_74838_a((String)("toolpart." + this.partName)).replaceAll("%%material", matName);
    }

    public String func_77667_c(ItemStack stack) {
        int id = this.getMaterialID(stack);
        if (id == -1) {
            return this.func_77658_a();
        }
        return "toolpart." + this.partName + "." + TConstructRegistry.getMaterial((int)id).materialName;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.hidden) {
            return;
        }
        for (Integer matID : TConstructRegistry.defaultToolPartMaterials) {
            ItemStack stack = new ItemStack(item, 1, matID.intValue());
            if (this.getMaterialID(stack) == -1) continue;
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int max = -1;
        for (Integer n : TConstructRegistry.toolMaterials.keySet()) {
            if (n <= max) continue;
            max = n;
        }
        this.icons = new IIcon[max + 1];
        if (!PHConstruct.minimalTextures) {
            for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
                String tex = this.modTexPrefix + ":" + this.folder + ((ToolMaterial)entry.getValue()).materialName.toLowerCase() + this.texture;
                if (!TextureHelper.itemTextureExists(tex)) continue;
                this.icons[((Integer)entry.getKey()).intValue()] = iconRegister.func_94245_a(tex);
            }
        }
        this.defaultIcon = iconRegister.func_94245_a(this.modTexPrefix + ":" + this.folder + this.texture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta > this.icons.length) {
            return this.defaultIcon;
        }
        if (this.icons[meta] == null) {
            return this.defaultIcon;
        }
        return this.icons[meta];
    }

    public int func_82790_a(ItemStack stack, int renderpass) {
        int matId = this.getMaterialID(stack);
        if (matId > this.icons.length) {
            return super.func_82790_a(stack, renderpass);
        }
        if (matId >= 0 && this.icons[matId] == null) {
            return TConstructRegistry.getMaterial(matId).primaryColor();
        }
        return super.func_82790_a(stack, renderpass);
    }
}

