/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.TextureHelper;
import tconstruct.util.config.PHConstruct;

public class DualMaterialToolPart
extends DynamicToolPart {
    public IIcon defaultIcon2;
    public IIcon[] icons2;

    public DualMaterialToolPart(String textureType, String name) {
        super(textureType, name);
    }

    public static ItemStack createDualMaterial(Item item, int mat1, int mat2) {
        ItemStack stack = new ItemStack(item, 1, mat1);
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound subtag = new NBTTagCompound();
        subtag.func_74768_a("Material2", mat2);
        tags.func_74782_a("DualMat", (NBTBase)subtag);
        stack.func_77982_d(tags);
        return stack;
    }

    public int getMaterialID2(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        int id = stack.func_77978_p().func_74775_l("DualMat").func_74762_e("Material2");
        if (TConstructRegistry.toolMaterials.keySet().contains(id)) {
            return id;
        }
        return -1;
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Integer matID : TConstructRegistry.toolMaterials.keySet()) {
            list.add(DualMaterialToolPart.createDualMaterial(item, matID, 2));
        }
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public boolean func_77623_v() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.icons2 = new IIcon[this.icons.length];
        if (!PHConstruct.minimalTextures) {
            for (Map.Entry<Integer, ToolMaterial> entry : TConstructRegistry.toolMaterials.entrySet()) {
                String tex = this.modTexPrefix + ":" + this.folder + entry.getValue().materialName.toLowerCase() + this.texture + "_2";
                if (!TextureHelper.itemTextureExists(tex)) continue;
                this.icons2[entry.getKey().intValue()] = iconRegister.func_94245_a(tex);
            }
        }
        this.defaultIcon2 = iconRegister.func_94245_a(this.modTexPrefix + ":" + this.folder + this.texture + "_2");
    }

    public IIcon func_77618_c(int meta, int pass) {
        if (pass > 0) {
            if (meta > this.icons.length) {
                return this.defaultIcon2;
            }
            if (this.icons2[meta] == null) {
                return this.defaultIcon2;
            }
            return this.icons2[meta];
        }
        return super.func_77618_c(meta, pass);
    }

    @Override
    public int func_82790_a(ItemStack stack, int renderpass) {
        if (renderpass > 0) {
            int matId = this.getMaterialID2(stack);
            if (matId > this.icons2.length) {
                return super.func_82790_a(stack, renderpass);
            }
            if (this.icons[matId] == null) {
                return TConstructRegistry.getMaterial(matId).primaryColor();
            }
            return super.func_82790_a(stack, renderpass);
        }
        return super.func_82790_a(stack, renderpass);
    }
}

