/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.tools.entity.LaunchedPotion;

public class PotionLauncher
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    public static final String[] textureNames = new String[]{"potionlauncher"};

    public PotionLauncher() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_77656_e(3);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        boolean loaded = tags.func_74767_n("Loaded");
        if (!loaded) {
            int slotID = this.getInventorySlotContainItem((Item)Items.field_151068_bn, player.field_71071_by);
            ItemStack potion = player.field_71071_by.func_70301_a(slotID);
            NBTTagCompound potionTag = new NBTTagCompound();
            potion.func_77955_b(potionTag);
            tags.func_74782_a("LoadedPotion", (NBTBase)potionTag);
            tags.func_74757_a("Loaded", true);
            if (!player.field_71075_bZ.field_75098_d) {
                --potion.field_77994_a;
                if (potion.field_77994_a < 1) {
                    player.field_71071_by.func_70299_a(slotID, null);
                }
            }
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "tinker:launcher_clank", 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.15f + 1.0f);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int time) {
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int slotID = this.getInventorySlotContainItem((Item)Items.field_151068_bn, player.field_71071_by);
        if (!tags.func_74767_n("Loaded") && slotID >= 0) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (!stack.func_77978_p().func_74775_l("InfiTool").func_74767_n("Loaded")) {
            return EnumAction.bow;
        }
        return EnumAction.none;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[0];
    }

    public void func_150895_a(Item b, CreativeTabs tabs, List list) {
        ItemStack stack = new ItemStack(b, 1, 0);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound tags = new NBTTagCompound();
        compound.func_74782_a("InfiTool", (NBTBase)tags);
        tags.func_74757_a("Loaded", false);
        stack.func_77982_d(compound);
        list.add(stack);
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        NBTTagCompound tags;
        if (stack != null && stack.func_77942_o() && (tags = stack.func_77978_p().func_74775_l("InfiTool")).func_74767_n("Loaded")) {
            NBTTagCompound potionTag = tags.func_74775_l("LoadedPotion");
            ItemStack potion = ItemStack.func_77949_a((NBTTagCompound)potionTag);
            if (potion != null) {
                World world = player.field_70170_p;
                world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new LaunchedPotion(world, player, potion));
                }
                tags.func_82580_o("LoadedPotion");
                tags.func_74757_a("Loaded", false);
            }
            return true;
        }
        return false;
    }

    ItemStack findPotion(EntityLivingBase living) {
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            int potionSlot = this.getInventorySlotContainItem((Item)Items.field_151068_bn, player.field_71071_by);
            if (potionSlot >= 0) {
                return player.field_71071_by.func_70301_a(potionSlot);
            }
        }
        return null;
    }

    int getInventorySlotContainItem(Item item, InventoryPlayer inventory) {
        for (int j = 0; j < inventory.field_70462_a.length; ++j) {
            if (inventory.field_70462_a[j] == null || inventory.field_70462_a[j].func_77973_b() != item) continue;
            return j;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"potionlauncher.tooltip"));
    }
}

