/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasBlending;
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasLight0;
    protected static boolean hasLight1;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static int boundTexIndex;
    protected static RenderItem renderItem;

    public static void renderOverlay() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || mc.field_71441_e == null || !Minecraft.func_71382_s() || mc.field_71474_y.field_74321_H.func_151470_d() || !ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_SHOW, true) || RayTracing.instance().getTarget() == null) {
            return;
        }
        if (RayTracing.instance().getTarget().field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && RayTracing.instance().getTargetStack() != null) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
        if (RayTracing.instance().getTarget().field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
    }

    public static void renderOverlay(Tooltip tooltip) {
        GL11.glPushMatrix();
        OverlayRenderer.saveGLState();
        GL11.glScalef((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        OverlayRenderer.drawTooltipBox(tooltip.x, tooltip.y, tooltip.w, tooltip.h, OverlayConfig.bgcolor, OverlayConfig.gradient1, OverlayConfig.gradient2);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tooltip.drawStrings();
        GL11.glDisable((int)3042);
        tooltip.drawIcons();
        if (tooltip.hasIcon) {
            RenderHelper.func_74520_c();
        }
        GL11.glEnable((int)32826);
        if (tooltip.hasIcon && tooltip.stack != null && tooltip.stack.func_77973_b() != null) {
            GuiContainerManager.drawItem((int)(tooltip.x + 5), (int)(tooltip.y + tooltip.h / 2 - 8), (ItemStack)tooltip.stack);
        }
        OverlayRenderer.loadGLState();
        GL11.glPopMatrix();
    }

    public static void saveGLState() {
        hasBlending = GL11.glGetBoolean((int)3042);
        hasLight = GL11.glGetBoolean((int)2896);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        boundTexIndex = GL11.glGetInteger((int)32873);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        if (hasBlending) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        if (hasLight1) {
            GL11.glEnable((int)16385);
        } else {
            GL11.glDisable((int)16385);
        }
        if (hasDepthTest) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        GL11.glBindTexture((int)3553, (int)boundTexIndex);
        GL11.glPopAttrib();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        GuiDraw.drawGradientRect((int)(x + 1), (int)y, (int)(w - 1), (int)1, (int)bg, (int)bg);
        GuiDraw.drawGradientRect((int)(x + 1), (int)(y + h), (int)(w - 1), (int)1, (int)bg, (int)bg);
        GuiDraw.drawGradientRect((int)(x + 1), (int)(y + 1), (int)(w - 1), (int)(h - 1), (int)bg, (int)bg);
        GuiDraw.drawGradientRect((int)x, (int)(y + 1), (int)1, (int)(h - 1), (int)bg, (int)bg);
        GuiDraw.drawGradientRect((int)(x + w), (int)(y + 1), (int)1, (int)(h - 1), (int)bg, (int)bg);
        GuiDraw.drawGradientRect((int)(x + 1), (int)(y + 2), (int)1, (int)(h - 3), (int)grad1, (int)grad2);
        GuiDraw.drawGradientRect((int)(x + w - 1), (int)(y + 2), (int)1, (int)(h - 3), (int)grad1, (int)grad2);
        GuiDraw.drawGradientRect((int)(x + 1), (int)(y + 1), (int)(w - 1), (int)1, (int)grad1, (int)grad1);
        GuiDraw.drawGradientRect((int)(x + 1), (int)(y + h - 1), (int)(w - 1), (int)1, (int)grad2, (int)grad2);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int w, int h, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + th) * f1));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)zLevel, (double)((float)(u + tw) * f), (double)((float)(v + th) * f1));
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)zLevel, (double)((float)(u + tw) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            OverlayRenderer.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        OverlayRenderer.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    static {
        renderItem = new RenderItem();
    }
}

