/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.thaumcraft;

import java.util.List;
import java.util.Map;
import mcp.mobius.waila.addons.thaumcraft.ThaumcraftModule;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.NBTUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class HUDHandlerIAspectContainer
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String aspect;
        if (!config.getConfig("thaumcraft.aspects")) {
            return currenttip;
        }
        ItemStack headSlot = accessor.getPlayer().field_71071_by.field_70460_b[3];
        if (headSlot == null) {
            return currenttip;
        }
        boolean hasReveal = ThaumcraftModule.IGoggles.isInstance(headSlot.func_77973_b());
        if (!hasReveal) {
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("Aspect") && tag.func_74764_b("Amount") && !tag.func_74779_i("Aspect").equals("")) {
            aspect = Character.toUpperCase(tag.func_74779_i("Aspect").charAt(0)) + tag.func_74779_i("Aspect").substring(1);
            currenttip.add(this.getAspectString(tag, "Aspect", "Amount", accessor));
        }
        if (tag.func_74764_b("aspect") && tag.func_74764_b("amount") && !tag.func_74779_i("aspect").equals("")) {
            aspect = Character.toUpperCase(tag.func_74779_i("aspect").charAt(0)) + tag.func_74779_i("aspect").substring(1);
            currenttip.add(this.getAspectString(tag, "aspect", "amount", accessor));
        }
        if (tag.func_74764_b("Aspects")) {
            NBTTagList taglist = tag.func_150295_c("Aspects", 10);
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound subtag = taglist.func_150305_b(i);
                if (!subtag.func_74764_b("amount") || !subtag.func_74764_b("key") || subtag.func_74779_i("key").equals("")) continue;
                currenttip.add(this.getAspectString(subtag, "key", "amount", accessor));
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    private String getAspectString(NBTTagCompound tag, String keyAspect, String keyAmount, IWailaDataAccessor accessor) {
        String aspect = tag.func_74779_i(keyAspect);
        aspect = this.knowAspect(aspect, accessor) ? aspect : "????";
        aspect = Character.toUpperCase(aspect.charAt(0)) + aspect.substring(1);
        String amount = String.valueOf(NBTUtil.getNBTInteger(tag, keyAmount));
        return String.format("%s" + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + "%s", aspect, amount);
    }

    private boolean knowAspect(String name, IWailaDataAccessor accessor) {
        try {
            Object[] aspects;
            Object proxy = ThaumcraftModule.TC_proxy.get(null);
            Object known = ThaumcraftModule.getKnownAspects.invoke(proxy, (Object[])null);
            Object listAspc = ((Map)known).get(accessor.getPlayer().getDisplayName());
            for (Object o : aspects = (Object[])ThaumcraftModule.list_getAspects.invoke(listAspc, new Object[0])) {
                if (!ThaumcraftModule.aspect_tag.get(o).equals(name)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
            return false;
        }
    }
}

