/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import tterrag.treesimulator.BlockEngine;
import tterrag.treesimulator.MessageBonemealParticles;
import tterrag.treesimulator.PacketHandlerTGS;
import tterrag.treesimulator.TileEngine;
import tterrag.treesimulator.TreeSimulator;

public class TickHandlerTGS {
    private double posX = 0.0;
    private double posZ = 0.0;
    private Map<String, Integer> counters = new HashMap<String, Integer>();
    private int ticksSinceLastCheck = 0;
    private PlayerState state = PlayerState.STANDING;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int movementCounter;
        Integer temp = this.counters.get(event.player.func_70005_c_());
        int n = movementCounter = temp == null ? 0 : temp;
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            if (this.ticksSinceLastCheck >= 5) {
                Set<Coord> coords = this.getNearestBlocks(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                if (coords.size() == 0) {
                    return;
                }
                if (Math.abs(player.field_70165_t - this.posX) > 0.5 || Math.abs(player.field_70161_v - this.posZ) > 0.5) {
                    ++movementCounter;
                    this.doEngines(coords, player.field_70170_p);
                }
                if (PlayerState.getState(player.func_70093_af()) != this.state) {
                    ++movementCounter;
                    this.doEngines(coords, player.field_70170_p);
                }
                if (movementCounter > TreeSimulator.waitTime) {
                    if (coords.size() == 0) {
                        --movementCounter;
                        this.updatePlayerPos(player);
                        return;
                    }
                    for (Coord pos : coords) {
                        Block block = player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z);
                        if (!(block instanceof BlockSapling)) continue;
                        BonemealEvent bonemeal = new BonemealEvent(player, player.field_70170_p, player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z), pos.x, pos.y, pos.z);
                        MinecraftForge.EVENT_BUS.post((Event)bonemeal);
                        BlockSapling sapling = (BlockSapling)block;
                        if ((double)player.field_70170_p.field_73012_v.nextFloat() < 0.45) {
                            sapling.func_149879_c(player.field_70170_p, pos.x, pos.y, pos.z, player.field_70170_p.field_73012_v);
                        }
                        if (!TreeSimulator.showParticles || sapling != Blocks.field_150345_g) break;
                        this.sendPacket(pos.x, pos.y, pos.z);
                        break;
                    }
                    movementCounter = 0;
                }
            } else {
                ++this.ticksSinceLastCheck;
            }
            this.state = PlayerState.getState(player.func_70093_af());
            this.updatePlayerPos(player);
            this.counters.put(event.player.func_70005_c_(), movementCounter);
        }
    }

    private void doEngines(Set<Coord> coords, World world) {
        for (Coord pos : coords) {
            TileEngine te;
            Block block = world.func_147439_a(pos.x, pos.y, pos.z);
            if (!(block instanceof BlockEngine) || (te = (TileEngine)world.func_147438_o(pos.x, pos.y, pos.z)) == null) continue;
            te.bumpEnergy(world.field_72995_K ? 0 : TreeSimulator.energyPerBump);
        }
    }

    private void sendPacket(int x, int y, int z) {
        PacketHandlerTGS.INSTANCE.sendToAll((IMessage)new MessageBonemealParticles(x, y, z));
    }

    private void updatePlayerPos(EntityPlayer player) {
        this.posX = player.field_70165_t;
        this.posZ = player.field_70161_v;
    }

    private Set<Coord> getNearestBlocks(World world, int xpos, int ypos, int zpos) {
        HashSet<Coord> list = new HashSet<Coord>();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    Block block = world.func_147439_a(x + xpos, y + ypos, z + zpos);
                    if (!(block instanceof BlockSapling) && !(block instanceof BlockEngine)) continue;
                    list.add(new Coord(x + xpos, y + ypos, z + zpos));
                }
            }
        }
        return list;
    }

    private class Coord {
        public int x;
        public int y;
        public int z;

        public Coord(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static enum PlayerState {
        CROUCHED,
        STANDING;


        public static PlayerState getState(boolean bool) {
            return bool ? CROUCHED : STANDING;
        }
    }
}

