/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules.addons;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Constants;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ModuleTinkers
extends Module {
    private String showDryerTime = "wawla.tinkers.showDryerTime";
    private String showDryerItem = "wawla.tinkers.showDryerItem";
    private String showFurnaceItem = "wawla.tinkers.showFurnace";
    private String showBurnTime = "wawla.tinkers.showBurnTime";
    private String hideLandmine = "wawla.tinkers.hideLandmine";
    public static boolean isEnabled = false;
    public static Class classHarvestTool = null;
    public static Class classDualHarvestTool = null;
    public static Class classLandmine = null;
    public static Class classDryingRackLogic = null;
    public static Class classFurnaceLogic = null;
    public static Method getHarvestType = null;
    public static Method getSecondHarvestType = null;

    public ModuleTinkers(boolean enabled) {
        super(enabled);
        if (enabled) {
            isEnabled = enabled;
            try {
                classHarvestTool = Class.forName("tconstruct.library.tools.HarvestTool");
                classDualHarvestTool = Class.forName("tconstruct.library.tools.DualHarvestTool");
                classLandmine = Class.forName("tconstruct.mechworks.blocks.BlockLandmine");
                classDryingRackLogic = Class.forName("tconstruct.blocks.logic.DryingRackLogic");
                classFurnaceLogic = Class.forName("tconstruct.tools.logic.FurnaceLogic");
                getHarvestType = classHarvestTool.getDeclaredMethod("getHarvestType", new Class[0]);
                getSecondHarvestType = classDualHarvestTool.getDeclaredMethod("getSecondHarvestType", new Class[0]);
                getHarvestType.setAccessible(true);
                getSecondHarvestType.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                Constants.LOG.info("The Tinkers Construct mod can not be detected. Module ignored.");
            }
            catch (NoSuchMethodException e) {
                Constants.LOG.info("There was in issue loading the Tinkers Construct module. It will be ignored.");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ItemStack onBlockOverride(ItemStack stack, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ItemStack cover;
        if (config.getConfig(this.hideLandmine) && accessor.getTileEntity() != null && Utilities.compareByClass(classLandmine, accessor.getBlock().getClass()) && accessor.getNBTData() != null && (cover = Utilities.getInventoryStacks(accessor.getNBTData(), 4)[3]) != null) {
            return cover;
        }
        return stack;
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        if (access.getBlock() != null && access.getTileEntity() != null) {
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), classDryingRackLogic)) {
                double percent;
                ItemStack item;
                if (config.getConfig(this.showDryerItem) && (item = Utilities.getInventoryStacks(access.getNBTData(), 1)[0]) != null) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.item") + ": " + item.func_82833_r());
                }
                if (config.getConfig(this.showDryerTime) && (percent = Utilities.round(Utilities.getProgression(access.getNBTData().func_74762_e("Time"), access.getNBTData().func_74762_e("MaxTime")), 2)) > 0.0 && !(percent > 100.0)) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.tinkers.dryness") + ": " + percent + "%");
                }
            }
            if (Utilities.compareTileEntityByClass(access.getTileEntity(), classFurnaceLogic)) {
                int burnTime;
                if (config.getConfig(this.showBurnTime) && (burnTime = access.getNBTData().func_74762_e("Fuel") / 20) > 0 && config.getConfig("wawla.furnace.burntime")) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.burnTime") + ": " + burnTime + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
                }
                if (config.getConfig(this.showFurnaceItem) && access.getPlayer().func_70093_af()) {
                    ItemStack[] furnaceStacks = Utilities.getInventoryStacks(access.getNBTData(), 3);
                    if (furnaceStacks[0] != null && config.getConfig("wawla.furnace.input")) {
                        tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.input") + ": " + furnaceStacks[0].func_82833_r() + " X " + furnaceStacks[0].field_77994_a);
                    }
                    if (furnaceStacks[1] != null && config.getConfig("wawla.furnace.fuel")) {
                        tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.fuel") + ": " + furnaceStacks[1].func_82833_r() + " X " + furnaceStacks[1].field_77994_a);
                    }
                    if (furnaceStacks[2] != null && config.getConfig("wawla.furnace.output")) {
                        tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.output") + ": " + furnaceStacks[2].func_82833_r() + " X " + furnaceStacks[2].field_77994_a);
                    }
                }
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        if (classDryingRackLogic != null) {
            register.registerSyncedNBTKey("*", classDryingRackLogic);
        }
        if (classFurnaceLogic != null) {
            register.registerSyncedNBTKey("*", classFurnaceLogic);
        }
        register.addConfig("Tinkers' Construct", this.hideLandmine);
        register.addConfig("Tinkers' Construct", this.showDryerTime);
        register.addConfig("Tinkers' Construct", this.showDryerItem);
        register.addConfig("Tinkers' Construct", this.showFurnaceItem);
    }

    public static boolean canHarvest(ItemStack item, String required) {
        if (isEnabled) {
            ArrayList<String> tooltypes = new ArrayList<String>();
            if (classDualHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getSecondHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (classHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tooltypes.contains(required);
        }
        return false;
    }
}

