/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ModuleLightLevel
extends Module {
    private String showDay = "wawla.light.showDay";
    private String showMonsterSpawn = "wawla.light.monsterSpawn";
    private String showLightLevel = "wawla.light.lightLevel";

    public ModuleLightLevel(boolean enabled) {
        super(enabled);
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        if (config.getConfig(this.showLightLevel) && (!access.getWorld().func_147445_c(access.getPosition().field_72311_b, access.getPosition().field_72312_c + 1, access.getPosition().field_72309_d, false) || access.getWorld().func_147437_c(access.getPosition().field_72311_b, access.getPosition().field_72312_c + 1, access.getPosition().field_72309_d))) {
            int dayLevel = this.getBlockLightLevel(access.getWorld(), access.getPosition().field_72311_b, access.getPosition().field_72312_c, access.getPosition().field_72309_d, true);
            int nightLevel = this.getBlockLightLevel(access.getWorld(), access.getPosition().field_72311_b, access.getPosition().field_72312_c, access.getPosition().field_72309_d, false);
            String display = StatCollector.func_74838_a((String)"tooltip.wawla.lightLevel") + ": ";
            if (config.getConfig(this.showMonsterSpawn)) {
                if (nightLevel <= 7) {
                    display = display + EnumChatFormatting.DARK_RED + "" + nightLevel + " ";
                } else if (nightLevel > 7) {
                    display = display + EnumChatFormatting.GREEN + "" + nightLevel + " ";
                }
            }
            if (config.getConfig(this.showDay)) {
                display = display + EnumChatFormatting.YELLOW + "(" + dayLevel + ")";
            }
            tooltip.add(display);
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.addConfig("Wawla-General", this.showLightLevel);
        register.addConfig("Wawla-General", this.showMonsterSpawn);
        register.addConfig("Wawla-General", this.showDay);
    }

    public int getBlockLightLevel(World world, int x, int y, int z, boolean day) {
        return day ? world.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y + 1, z & 0xF, 0) : world.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y + 1, z & 0xF, 16);
    }
}

