/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.minecraft.block.BlockBeacon;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.StatCollector;

public class ModuleBeacons
extends Module {
    private String showLevels = "wawla.beacon.showLevels";
    private String showPrimary = "wawla.beacon.showPrimary";
    private String showSecondary = "wawla.beacon.showSecondary";

    public ModuleBeacons(boolean enabled) {
        super(enabled);
    }

    @Override
    public void onWailaBlockDescription(ItemStack stack, List<String> tooltip, IWailaDataAccessor access, IWailaConfigHandler config) {
        if (access.getTileEntity() != null && access.getTileEntity() instanceof TileEntityBeacon) {
            NBTTagCompound tag = access.getNBTData();
            int level = tag.func_74762_e("Levels");
            int primary = tag.func_74762_e("Primary");
            int secondary = tag.func_74762_e("Secondary");
            if (config.getConfig(this.showLevels)) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.levels") + ": " + level);
            }
            if (config.getConfig(this.showPrimary) && primary > 0) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.primary") + ": " + StatCollector.func_74838_a((String)Potion.field_76425_a[primary].func_76393_a()));
            }
            if (config.getConfig(this.showSecondary) && secondary > 0) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wawla.secondary") + ": " + StatCollector.func_74838_a((String)Potion.field_76425_a[secondary].func_76393_a()));
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.registerSyncedNBTKey("*", BlockBeacon.class);
        register.addConfig("Wawla-Blocks", this.showLevels);
        register.addConfig("Wawla-Blocks", this.showPrimary);
        register.addConfig("Wawla-Blocks", this.showSecondary);
    }
}

