/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.util.nbt.NBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelperTarget {
    public int posX = 0;
    public int posY = 0;
    public int posZ = 0;
    public double dPosX = 0.0;
    public double dPosY = 0.0;
    public double dPosZ = 0.0;
    public int dimension = 0;
    public int blockFace = -1;

    public static boolean hasTargetTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Target", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        return tag != null && tag.func_150297_b("posX", 99) && tag.func_150297_b("posY", 99) && tag.func_150297_b("posZ", 99) && tag.func_150297_b("Dim", 3);
    }

    public NBTTagCompound readTargetTagFromNBT(NBTTagCompound nbt) {
        if (!NBTHelperTarget.hasTargetTag(nbt)) {
            return null;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        this.posX = tag.func_74762_e("posX");
        this.posY = tag.func_74762_e("posY");
        this.posZ = tag.func_74762_e("posZ");
        this.dimension = tag.func_74762_e("Dim");
        this.blockFace = tag.func_74762_e("BlockFace");
        this.dPosX = tag.func_150297_b("dPosX", 6) ? tag.func_74769_h("dPosX") : (double)this.posX + 0.5;
        this.dPosY = tag.func_150297_b("dPosY", 6) ? tag.func_74769_h("dPosY") : (double)this.posY;
        this.dPosZ = tag.func_150297_b("dPosZ", 6) ? tag.func_74769_h("dPosZ") : (double)this.posZ + 0.5;
        return tag;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, int pX, int pY, int pZ, int dim, int face, double hitX, double hitY, double hitZ, boolean doHitOffset) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        double x = pX;
        double y = pY;
        double z = pZ;
        if (doHitOffset) {
            x += hitX;
            y += hitY;
            z += hitZ;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("posX", (int)x);
        tag.func_74768_a("posY", (int)y);
        tag.func_74768_a("posZ", (int)z);
        tag.func_74768_a("Dim", dim);
        tag.func_74768_a("BlockFace", face);
        tag.func_74780_a("dPosX", x);
        tag.func_74780_a("dPosY", y);
        tag.func_74780_a("dPosZ", z);
        nbt.func_74782_a("Target", (NBTBase)tag);
        return nbt;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("posX", this.posX);
        tag.func_74768_a("posY", this.posY);
        tag.func_74768_a("posZ", this.posZ);
        tag.func_74768_a("Dim", this.dimension);
        tag.func_74768_a("BlockFace", this.blockFace);
        tag.func_74780_a("dPosX", this.dPosX);
        tag.func_74780_a("dPosY", this.dPosY);
        tag.func_74780_a("dPosZ", this.dPosZ);
        nbt.func_74782_a("Target", (NBTBase)tag);
        return nbt;
    }

    public static NBTTagCompound removeTargetTagFromNBT(NBTTagCompound nbt) {
        return NBTHelper.writeTagToNBT((NBTTagCompound)nbt, (String)"Target", null);
    }
}

