/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemNBTHelper {
    public int posX = 0;
    public int posY = 0;
    public int posZ = 0;
    public int dimension = 0;
    public int blockFace = -1;
    public long playerUUIDMost;
    public long playerUUIDLeast;
    public String playerName = "";

    public static boolean hasTargetTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Target", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        return tag != null && tag.func_150297_b("posX", 99) && tag.func_150297_b("posY", 99) && tag.func_150297_b("posZ", 99) && tag.func_150297_b("Dim", 3);
    }

    public NBTTagCompound readTargetTagFromNBT(NBTTagCompound nbt) {
        if (!ItemNBTHelper.hasTargetTag(nbt)) {
            return null;
        }
        NBTTagCompound tagTarget = nbt.func_74775_l("Target");
        this.posX = tagTarget.func_74762_e("posX");
        this.posY = tagTarget.func_74762_e("posY");
        this.posZ = tagTarget.func_74762_e("posZ");
        this.dimension = tagTarget.func_74762_e("Dim");
        this.blockFace = tagTarget.func_74762_e("BlockFace");
        return tagTarget;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, int x, int y, int z, int dim, int face, boolean calculateOffset) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (calculateOffset && face >= 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)face);
            x += dir.offsetX;
            y += dir.offsetY;
            z += dir.offsetZ;
        }
        NBTTagCompound tagTarget = new NBTTagCompound();
        tagTarget.func_74768_a("posX", x);
        tagTarget.func_74768_a("posY", y);
        tagTarget.func_74768_a("posZ", z);
        tagTarget.func_74768_a("Dim", dim);
        tagTarget.func_74768_a("BlockFace", face);
        nbt.func_74782_a("Target", (NBTBase)tagTarget);
        return nbt;
    }

    public static NBTTagCompound removeTargetTagFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_82580_o("Target");
        }
        return nbt;
    }

    public static boolean hasPlayerTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Player", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Player");
        return tag != null && tag.func_150297_b("PlayerUUIDMost", 4) && tag.func_150297_b("PlayerUUIDLeast", 4) && tag.func_150297_b("PlayerName", 8);
    }

    public NBTTagCompound readPlayerTagFromNBT(NBTTagCompound nbt) {
        if (!ItemNBTHelper.hasPlayerTag(nbt)) {
            return null;
        }
        NBTTagCompound tagPlayer = nbt.func_74775_l("Player");
        this.playerUUIDMost = tagPlayer.func_74763_f("PlayerUUIDMost");
        this.playerUUIDLeast = tagPlayer.func_74763_f("PlayerUUIDLeast");
        this.playerName = tagPlayer.func_74779_i("PlayerName");
        return tagPlayer;
    }

    public static NBTTagCompound writePlayerTagToNBT(NBTTagCompound nbt, EntityPlayer player) {
        if (nbt == null) {
            return nbt;
        }
        if (player == null) {
            nbt.func_82580_o("Player");
            return nbt;
        }
        NBTTagCompound tagPlayer = new NBTTagCompound();
        tagPlayer.func_74772_a("PlayerUUIDMost", player.func_110124_au().getMostSignificantBits());
        tagPlayer.func_74772_a("PlayerUUIDLeast", player.func_110124_au().getLeastSignificantBits());
        tagPlayer.func_74778_a("PlayerName", player.func_70005_c_());
        nbt.func_74782_a("Player", (NBTBase)tagPlayer);
        return nbt;
    }

    public static ItemStack writeTagToItem(ItemStack stack, String name, NBTTagCompound tag) {
        if (stack == null || name == null) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            if (tag == null) {
                return stack;
            }
            nbt = new NBTTagCompound();
        }
        if (tag == null) {
            nbt.func_82580_o(name);
        } else {
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack writeNBTToItem(ItemStack stack, NBTTagCompound nbt) {
        if (stack != null) {
            stack.func_77982_d(nbt);
        }
        return stack;
    }
}

