/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.setup.EURegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class EntityUtils {
    public static EntityPlayerMP findPlayerFromUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        if (mcs == null) {
            return null;
        }
        List playerList = mcs.func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : playerList) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Entity findEntityByUUID(List<Entity> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static Entity getBottomEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70154_o != null) {
            ent = ent.field_70154_o;
        }
        return ent;
    }

    public static Entity getTopEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70153_n != null) {
            ent = ent.field_70153_n;
        }
        return ent;
    }

    public static boolean doesEntityStackHavePlayers(Entity entity) {
        Entity ent = entity;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackHaveBlacklistedEntities(Entity entity) {
        List<String> blacklist = EURegistry.getTeleportBlacklist();
        Entity ent = entity;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean unmountRider(Entity entity) {
        if (entity != null && entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static boolean unmountRidden(Entity entity) {
        if (entity != null && entity.field_70154_o != null) {
            entity.func_70078_a(null);
            return true;
        }
        return false;
    }
}

