/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderFurnace;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.gui.container.ContainerEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEU;
import fi.dy.masa.enderutilities.util.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityEnderFurnace
extends TileEntityEU {
    public static final int COOKTIME_INC_NOFUEL = 1;
    public static final int COOKTIME_INC_SLOW = 20;
    public static final int COOKTIME_INC_FAST = 60;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int OUTPUT_BUFFER_SIZE = 1024;
    public static final int OUTPUT_INTERVAL = 20;
    protected static final int[] SLOTS_SIDES = new int[]{0, 1, 2};
    @SideOnly(value=Side.CLIENT)
    public boolean isActive;
    @SideOnly(value=Side.CLIENT)
    public boolean usingFuel;
    public byte operatingMode;
    public byte outputMode;
    private int outputBufferAmount;
    private ItemStack outputBufferStack;
    public int burnTimeRemaining;
    public int burnTimeFresh;
    public int cookTime;
    public int cookTimeFresh;
    private boolean isBurningLast;
    private boolean isCookingLast;
    private int timer;

    public TileEntityEnderFurnace() {
        super("enderfurnace");
        this.itemStacks = new ItemStack[3];
        this.operatingMode = 0;
        this.outputMode = 0;
        this.burnTimeRemaining = 0;
        this.cookTime = 0;
        this.ownerName = null;
        this.ownerUUID = null;
        this.timer = 0;
        this.outputBufferAmount = 0;
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customInventoryName : "container.enderfurnace";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        byte flags = nbt.func_74771_c("Flags");
        this.operatingMode = (byte)(flags & 1);
        this.outputMode = (byte)(flags >> 1 & 1);
        this.burnTimeRemaining = nbt.func_74762_e("BurnTimeRemaining");
        this.burnTimeFresh = nbt.func_74762_e("BurnTimeFresh");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeFresh = nbt.func_74762_e("CookTimeFresh");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.itemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte slotNum = nbttagcompound.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.itemStacks.length) continue;
            this.itemStacks[slotNum] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        if (nbt.func_150297_b("OutputBufferAmount", 3) && nbt.func_150297_b("OutputBufferStack", 10)) {
            this.outputBufferAmount = nbt.func_74762_e("OutputBufferAmount");
            this.outputBufferStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("OutputBufferStack"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        byte flags = 0;
        flags = (byte)(flags | this.operatingMode & 1);
        flags = (byte)(flags | (this.outputMode & 1) << 1);
        nbt.func_74774_a("Flags", flags);
        nbt.func_74777_a("BurnTimeRemaining", (short)this.burnTimeRemaining);
        nbt.func_74777_a("BurnTimeFresh", (short)this.burnTimeFresh);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        nbt.func_74777_a("CookTimeFresh", (short)this.cookTimeFresh);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.outputBufferStack != null) {
            nbt.func_74782_a("OutputBufferStack", (NBTBase)this.outputBufferStack.func_77955_b(new NBTTagCompound()));
            nbt.func_74768_a("OutputBufferAmount", this.outputBufferAmount);
        }
    }

    public Packet func_145844_m() {
        if (this.field_145850_b != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            byte flags = (byte)(this.getRotation() & 7);
            if (this.canSmelt()) {
                flags = (byte)(flags | 0x10);
            }
            if (this.isBurning()) {
                flags = (byte)(flags | 0x20);
            }
            if (this.operatingMode == 1) {
                flags = (byte)(flags | 0x40);
            }
            if (this.outputMode == 1) {
                flags = (byte)(flags | 0x80);
            }
            nbt.func_74774_a("f", flags);
            nbt.func_74768_a("b", this.outputBufferAmount);
            if (this.ownerName != null) {
                nbt.func_74778_a("o", this.ownerName);
            }
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        byte flags = nbt.func_74771_c("f");
        this.setRotation((byte)(flags & 7));
        this.isActive = (flags & 0x10) == 16;
        this.usingFuel = (flags & 0x20) == 32;
        this.operatingMode = (byte)((flags & 0x40) >> 6);
        this.outputMode = (byte)((flags & 0x80) >> 7);
        this.outputBufferAmount = nbt.func_74762_e("b");
        if (nbt.func_150297_b("o", 8)) {
            this.ownerName = nbt.func_74779_i("o");
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.cookTime * i / this.cookTimeFresh;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTimeFresh == 0) {
            return 0;
        }
        return this.burnTimeRemaining * i / this.burnTimeFresh;
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean needsSync = false;
        boolean dirty = false;
        if (this.fillOutputSlotFromBuffer()) {
            needsSync = true;
        }
        int cookTimeIncrement = 20;
        if (this.burnTimeRemaining == 0 && !this.hasFuelAvailable()) {
            cookTimeIncrement = 1;
        } else if (this.operatingMode == 1) {
            cookTimeIncrement = 60;
        }
        if (this.burnTimeRemaining > 0) {
            int btUse = 20;
            if (this.operatingMode == 1) {
                btUse = 120;
            }
            if (btUse > this.burnTimeRemaining) {
                if (this.hasFuelAvailable() && this.canSmelt()) {
                    this.burnTimeRemaining += this.consumeFuelItem();
                } else {
                    cookTimeIncrement = this.burnTimeRemaining * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining;
                }
            }
            this.burnTimeRemaining -= btUse;
            dirty = true;
        } else if (this.canSmelt() && this.hasFuelAvailable()) {
            this.burnTimeRemaining += this.consumeFuelItem();
            dirty = true;
        }
        if (this.canSmelt()) {
            this.cookTimeFresh = 1200;
            this.cookTime += cookTimeIncrement;
            if (this.cookTime >= this.cookTimeFresh) {
                this.smeltItem();
                needsSync = true;
                this.cookTime = this.canSmelt() && this.cookTime > this.cookTimeFresh ? (this.cookTime -= this.cookTimeFresh) : 0;
            }
            if (this.burnTimeRemaining == 0 && this.hasFuelAvailable() && this.canSmelt()) {
                this.burnTimeRemaining += this.consumeFuelItem();
            }
            dirty = true;
        } else {
            if (this.cookTime != 0) {
                dirty = true;
            }
            this.cookTime = 0;
            this.cookTimeFresh = 0;
        }
        if (this.outputMode == 1 && this.itemStacks[2] != null && this.itemStacks[2].field_77994_a > 0 && ++this.timer >= 20) {
            this.timer = 0;
            if (this.moveItemsToEnderChest()) {
                dirty = true;
                needsSync = true;
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (needsSync || this.isBurningLast != this.isBurning() || this.isCookingLast != this.canSmelt()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.isBurningLast = this.isBurning();
        this.isCookingLast = this.canSmelt();
    }

    private boolean fillOutputSlotFromBuffer() {
        int max;
        int size;
        if (this.outputBufferAmount == 0 || this.outputBufferStack == null) {
            return false;
        }
        if (this.itemStacks[2] == null) {
            this.itemStacks[2] = this.outputBufferStack.func_77946_l();
            this.itemStacks[2].field_77994_a = 0;
        }
        if ((size = this.itemStacks[2].field_77994_a) == (max = Math.min(this.func_70297_j_(), this.itemStacks[2].func_77976_d()))) {
            return false;
        }
        max = Math.min(max - size, this.outputBufferAmount);
        this.itemStacks[2].field_77994_a += max;
        this.outputBufferAmount -= max;
        if (this.outputBufferAmount <= 0) {
            this.outputBufferStack = null;
        }
        return true;
    }

    private boolean moveItemsToEnderChest() {
        EntityPlayerMP player = EntityUtils.findPlayerFromUUID(this.ownerUUID);
        boolean movedSomething = false;
        if (player != null) {
            InventoryEnderChest invEnderChest = player.func_71005_bN();
            int size = 0;
            for (int i = 0; i < invEnderChest.func_70302_i_(); ++i) {
                size = 0;
                ItemStack enderChestStack = invEnderChest.func_70301_a(i);
                if (enderChestStack != null) {
                    size = enderChestStack.field_77994_a;
                }
                if (enderChestStack != null && (invEnderChest.func_70297_j_() - size <= 0 || !this.itemStacks[2].func_77969_a(enderChestStack) || !ItemStack.func_77970_a((ItemStack)this.itemStacks[2], (ItemStack)enderChestStack))) continue;
                if (enderChestStack == null) {
                    enderChestStack = this.itemStacks[2].func_77946_l();
                }
                int moved = Math.min(this.itemStacks[2].field_77994_a, invEnderChest.func_70297_j_() - size);
                enderChestStack.field_77994_a = size + moved;
                invEnderChest.func_70299_a(i, enderChestStack);
                this.itemStacks[2].field_77994_a -= moved;
                if (this.itemStacks[2].field_77994_a <= 0) {
                    this.itemStacks[2] = null;
                    break;
                }
                movedSomething = true;
            }
        }
        return movedSomething;
    }

    public int getOutputBufferAmount() {
        return this.outputBufferAmount;
    }

    public ItemStack getOutputBufferStack() {
        return this.outputBufferStack;
    }

    public boolean hasFuelAvailable() {
        if (this.itemStacks[1] == null) {
            return false;
        }
        return TileEntityEnderFurnace.getItemBurnTime(this.itemStacks[1]) > 0 || TileEntityEnderFurnace.itemContainsFluidFuel(this.itemStacks[1]);
    }

    public int consumeFuelItem() {
        if (this.itemStacks[1] == null) {
            return 0;
        }
        int burnTime = TileEntityEnderFurnace.getItemBurnTime(this.itemStacks[1]);
        if (burnTime > 0) {
            if (--this.itemStacks[1].field_77994_a <= 0) {
                this.itemStacks[1] = this.itemStacks[1].func_77973_b().getContainerItem(this.itemStacks[1]);
            }
            this.burnTimeFresh = burnTime;
        } else if (TileEntityEnderFurnace.itemContainsFluidFuel(this.itemStacks[1])) {
            this.burnTimeFresh = burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(this.itemStacks[1]);
        }
        return burnTime;
    }

    public boolean canSmelt() {
        if (this.itemStacks[0] == null) {
            return false;
        }
        ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(this.itemStacks[0]);
        if (resultStack == null) {
            return false;
        }
        if (this.itemStacks[2] == null && this.outputBufferAmount == 0) {
            return true;
        }
        if (!(this.itemStacks[2] == null || this.itemStacks[2].func_77969_a(resultStack) && ItemStack.func_77970_a((ItemStack)this.itemStacks[2], (ItemStack)resultStack))) {
            return false;
        }
        if (!(this.outputBufferStack == null || this.outputBufferStack.func_77969_a(resultStack) && ItemStack.func_77970_a((ItemStack)this.outputBufferStack, (ItemStack)resultStack))) {
            return false;
        }
        int amount = 0;
        int stackLimit = Math.min(this.func_70297_j_(), resultStack.func_77976_d());
        if (this.itemStacks[2] != null) {
            amount = this.itemStacks[2].field_77994_a;
        }
        return (amount = amount + this.outputBufferAmount + resultStack.field_77994_a) <= 1024 + stackLimit;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            int resultAmount;
            ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(this.itemStacks[0]);
            int stackLimit = Math.min(this.func_70297_j_(), resultStack.func_77976_d());
            if (this.itemStacks[2] == null) {
                this.itemStacks[2] = resultStack.func_77946_l();
                this.itemStacks[2].field_77994_a = 0;
            }
            if (this.itemStacks[2].field_77994_a + (resultAmount = resultStack.field_77994_a) <= stackLimit) {
                this.itemStacks[2].field_77994_a += resultAmount;
            } else {
                int max = stackLimit - this.itemStacks[2].field_77994_a;
                this.itemStacks[2].field_77994_a += max;
                this.outputBufferAmount += resultAmount - max;
                if (this.outputBufferStack == null) {
                    this.outputBufferStack = resultStack.func_77946_l();
                    this.outputBufferStack.field_77994_a = 1;
                }
            }
            if (--this.itemStacks[0].field_77994_a <= 0) {
                this.itemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block.func_149688_o() == Material.field_151575_d) {
                return 2700;
            }
            if (block == Blocks.field_150402_ci) {
                return 144000;
            }
            if (block == Blocks.field_150376_bx) {
                return 1350;
            }
        } else {
            if (item == Items.field_151044_h) {
                return 14400;
            }
            if (item == Items.field_151072_bj) {
                return 21600;
            }
            if (item == Items.field_151065_br) {
                return 10800;
            }
            if (item == Items.field_151079_bi) {
                return 9600;
            }
            if (item == Items.field_151061_bv) {
                return 20400;
            }
            if (item == Items.field_151129_at) {
                return 180000;
            }
            if (item == Items.field_151055_y) {
                return 900;
            }
            if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
                return 900;
            }
            if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
                return 1800;
            }
        }
        return GameRegistry.getFuelValue((ItemStack)stack) * 1200 * 3 / 400;
    }

    public static int consumeFluidFuelDosage(ItemStack stack) {
        if (!TileEntityEnderFurnace.itemContainsFluidFuel(stack)) {
            return 0;
        }
        int burnTime = 0;
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        if (fluidStack.getFluid().getName().equals("lava")) {
            int amount = Math.min(250, fluidStack.amount);
            burnTime = amount * 15 * 1200 / 100;
            ((IFluidContainerItem)stack.func_77973_b()).drain(stack, amount, true);
        }
        return burnTime;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityEnderFurnace.itemContainsFluidFuel(stack) || TileEntityEnderFurnace.getItemBurnTime(stack) > 0;
    }

    public static boolean itemContainsFluidFuel(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IFluidContainerItem)) {
            return false;
        }
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        return fluid.getName().equals("lava");
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack itemStack) {
        if (slotNum == 2) {
            return false;
        }
        if (slotNum == 1) {
            return TileEntityEnderFurnace.isItemFuel(itemStack);
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS_SIDES;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot == 1) {
            return !TileEntityEnderFurnace.isItemFuel(stack);
        }
        return slot == 2 && (this.outputMode & 1) == 0;
    }

    @Override
    public ContainerEnderFurnace getContainer(InventoryPlayer inventory) {
        return new ContainerEnderFurnace(this, inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilitiesInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiEnderFurnace(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public void performGuiAction(int element, short action) {
        if (element == 0) {
            this.operatingMode = (byte)(this.operatingMode + 1);
            if (this.operatingMode > 1) {
                this.operatingMode = 0;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (element == 1) {
            this.outputMode = (byte)(this.outputMode + 1);
            if (this.outputMode > 1) {
                this.outputMode = 0;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

