/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEU;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class MessageGuiAction
implements IMessage,
IMessageHandler<MessageGuiAction, IMessage> {
    private int guiId;
    private int elementId;
    private short action;
    private int dimension;
    private int posX;
    private int posY;
    private int posZ;

    public MessageGuiAction() {
    }

    public MessageGuiAction(int dim, int x, int y, int z, int guiId, int element, short action) {
        this.guiId = guiId;
        this.elementId = element;
        this.action = action;
        this.dimension = dim;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.guiId = buf.readInt();
        this.elementId = buf.readInt();
        this.action = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.guiId);
        buf.writeInt(this.elementId);
        buf.writeShort((int)this.action);
    }

    public IMessage onMessage(MessageGuiAction message, MessageContext ctx) {
        EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.dimension);
        if (player != null && world != null) {
            switch (message.guiId) {
                case 0: {
                    TileEntity te = world.func_147438_o(message.posX, message.posY, message.posZ);
                    if (te == null || !(te instanceof TileEntityEU)) break;
                    ((TileEntityEU)te).performGuiAction(message.elementId, message.action);
                    break;
                }
            }
        }
        return null;
    }
}

