/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.effects.Particles;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MessageAddEffects
implements IMessage,
IMessageHandler<MessageAddEffects, IMessage> {
    public static final int SOUND = 1;
    public static final int PARTICLES = 2;
    public static final int EFFECT_TELEPORT = 1;
    private int effectType;
    private int flags;
    double x;
    double y;
    double z;

    public MessageAddEffects() {
    }

    public MessageAddEffects(int id, int flags, double x, double y, double z) {
        this.effectType = id;
        this.flags = flags;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.effectType = buf.readInt();
        this.flags = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.effectType);
        buf.writeInt(this.flags);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public IMessage onMessage(MessageAddEffects message, MessageContext ctx) {
        EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
        World world = player.field_70170_p;
        if (player != null && world != null && message.effectType == 1) {
            if ((message.flags & 1) == 1) {
                // empty if block
            }
            if ((message.flags & 2) == 2) {
                Particles.spawnParticles(world, "portal", message.x, message.y, message.z, 32, 0.2, 2.0);
            }
        }
        return null;
    }
}

