/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.item.IKeyBound;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.setup.EUConfigs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.ItemFluidContainer;

public class ItemEnderBucket
extends ItemFluidContainer
implements IKeyBound {
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_PICKUP = 1;
    public static final byte MODE_DEPOSIT = 2;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] iconParts;

    public ItemEnderBucket() {
        this(Item.func_150891_b((Item)GameRegistry.findItem((String)"enderutilities", (String)"enderbucket")));
    }

    public ItemEnderBucket(int itemID) {
        super(itemID);
        this.func_77625_d(1);
        this.func_77655_b("enderbucket");
        this.func_111206_d(Textures.getTextureName(this.func_77658_a()) + ".32");
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.setCapacity(16000);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        this.useBucket(stack, world, player);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        this.useBucket(stack, world, player);
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null && fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            return super.func_77653_i(stack) + " (" + fluidStack.getFluid().getLocalizedName(fluidStack) + ")";
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String fluidName;
        FluidStack fluidStack = this.getFluid(itemStack);
        String pre = "" + EnumChatFormatting.BLUE;
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        String modeStr = "gui.tooltip.bucket.mode.normal";
        int amount = 0;
        if (fluidStack != null && fluidStack.getFluid() != null) {
            amount = fluidStack.amount;
            fluidName = pre + fluidStack.getFluid().getLocalizedName(fluidStack) + rst;
        } else {
            fluidName = "<" + StatCollector.func_74838_a((String)"gui.tooltip.empty") + ">";
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Mode")) {
            byte mode = nbt.func_74771_c("Mode");
            if (mode == 1) {
                modeStr = "gui.tooltip.bucket.mode.pickup";
            } else if (mode == 2) {
                modeStr = "gui.tooltip.bucket.mode.deposit";
            }
        }
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.fluid") + ": " + fluidName);
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.amount") + String.format(": %d mB", amount));
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.mode") + ": " + StatCollector.func_74838_a((String)modeStr));
    }

    public boolean useBucket(ItemStack itemStack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        this.setCapacity(EUConfigs.enderBucketCapacity.getInt(16000));
        byte bucketMode = this.getBucketMode(itemStack);
        FluidStack storedFluidStack = this.getFluid(itemStack);
        int storedFluidAmount = 0;
        if (storedFluidStack != null) {
            storedFluidAmount = storedFluidStack.amount;
        }
        if ((movingobjectposition = this.func_77621_a(world, player, true)) == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        int x = movingobjectposition.field_72311_b;
        int y = movingobjectposition.field_72312_c;
        int z = movingobjectposition.field_72309_d;
        Block targetBlock = world.func_147439_a(x, y, z);
        if (targetBlock == null || targetBlock.func_149688_o() == null || !world.func_72962_a(player, x, y, x)) {
            return false;
        }
        if (targetBlock.func_149688_o().func_76224_d()) {
            Fluid storedFluid = null;
            Fluid targetFluid = null;
            IFluidBlock iFluidBlock = null;
            FluidStack fluidStack = null;
            if (storedFluidStack != null) {
                storedFluid = storedFluidStack.getFluid();
            }
            if (targetBlock instanceof IFluidBlock) {
                iFluidBlock = (IFluidBlock)targetBlock;
                targetFluid = iFluidBlock.getFluid();
            } else {
                if (targetBlock == Blocks.field_150358_i) {
                    targetBlock = Blocks.field_150355_j;
                } else if (targetBlock == Blocks.field_150356_k) {
                    targetBlock = Blocks.field_150353_l;
                }
                targetFluid = FluidRegistry.lookupFluidForBlock((Block)targetBlock);
            }
            if (!(bucketMode == 2 || storedFluidAmount != 0 && (this.getCapacity(itemStack) - storedFluidAmount < 1000 || storedFluid != targetFluid || player.func_70093_af() && bucketMode != 1))) {
                if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemStack)) {
                    return false;
                }
                if (iFluidBlock != null) {
                    if (iFluidBlock.canDrain(world, x, y, z) && this.fill(itemStack, fluidStack = iFluidBlock.drain(world, x, y, z, false), false) <= this.getCapacity(itemStack) - storedFluidAmount) {
                        fluidStack = iFluidBlock.drain(world, x, y, z, true);
                        this.fill(itemStack, fluidStack, true);
                        return true;
                    }
                    return false;
                }
                if (targetFluid != null) {
                    fluidStack = FluidRegistry.getFluidStack((String)targetFluid.getName(), (int)1000);
                }
                if (this.fill(itemStack, fluidStack, false) >= 1000 && world.func_147468_f(x, y, z)) {
                    this.fill(itemStack, fluidStack, true);
                    return true;
                }
                return false;
            }
            if (storedFluidAmount >= 1000 && bucketMode != 1) {
                if ((storedFluid != targetFluid || player.func_70093_af()) && this.tryPlaceContainedFluid(world, x, y, z, storedFluidStack)) {
                    this.drain(itemStack, 1000, true);
                    return true;
                }
                return false;
            }
        } else {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof IFluidHandler) {
                FluidStack fluidStack;
                IFluidHandler iFluidHandler = (IFluidHandler)te;
                ForgeDirection fDir = ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e);
                if (bucketMode == 1 || !player.func_70093_af() && bucketMode != 2) {
                    int space = this.getCapacity(itemStack) - storedFluidAmount;
                    if (space > 0) {
                        FluidStack fluidStack2;
                        if (space > 1000) {
                            space = 1000;
                        }
                        if ((fluidStack2 = iFluidHandler.drain(fDir, space, false)) != null && (storedFluidAmount == 0 || fluidStack2.isFluidEqual(storedFluidStack))) {
                            fluidStack2 = iFluidHandler.drain(fDir, space, true);
                            this.fill(itemStack, fluidStack2, true);
                            return true;
                        }
                    }
                } else if (storedFluidAmount > 0 && iFluidHandler.fill(fDir, fluidStack = this.drain(itemStack, 1000, false), false) > 0) {
                    int amount = iFluidHandler.fill(fDir, fluidStack, true);
                    this.drain(itemStack, amount, true);
                    return true;
                }
            } else if (storedFluidAmount >= 1000 && bucketMode != 1) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e);
                if (this.tryPlaceContainedFluid(world, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ, storedFluidStack)) {
                    this.drain(itemStack, 1000, true);
                    return true;
                }
            }
        }
        return false;
    }

    public byte getBucketMode(ItemStack stack) {
        byte mode;
        NBTTagCompound nbt;
        if (stack != null && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("Mode") && (mode = nbt.func_74771_c("Mode")) >= 0 && mode <= 2) {
            return mode;
        }
        return 0;
    }

    public boolean tryPlaceContainedFluid(World world, int x, int y, int z, FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || fluidStack.getFluid().getBlock() == null || !fluidStack.getFluid().canBePlacedInWorld()) {
            return false;
        }
        Block block = fluidStack.getFluid().getBlock();
        if (block == Blocks.field_150355_j) {
            block = Blocks.field_150358_i;
        } else if (block == Blocks.field_150353_l) {
            block = Blocks.field_150356_k;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && block == Blocks.field_150358_i) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, block, 0, 3);
        }
        return true;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int drained = 0;
        NBTTagCompound nbt = container.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
            return null;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        if (fluidStack == null) {
            return null;
        }
        drained = Math.min(fluidStack.amount, maxDrain);
        if (doDrain) {
            if (drained >= fluidStack.amount) {
                nbt.func_82580_o("Fluid");
                if (nbt.func_82582_d()) {
                    container.func_77982_d(null);
                }
            } else {
                NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
                fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        fluidStack.amount = drained;
        return fluidStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.iconParts = new IIcon[3];
        this.iconParts[0] = iconRegister.func_94245_a(Textures.getTextureName(this.func_77658_a()) + ".32.main");
        this.iconParts[1] = iconRegister.func_94245_a(Textures.getTextureName(this.func_77658_a()) + ".32.windowbg");
        this.iconParts[2] = iconRegister.func_94245_a(Textures.getTextureName(this.func_77658_a()) + ".32.inside");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconPart(int i) {
        if (i >= this.iconParts.length) {
            i = 0;
        }
        return this.iconParts[i];
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0) {
            byte val = 0;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                val = nbt.func_74771_c("Mode");
            } else {
                nbt = new NBTTagCompound();
            }
            val = (byte)(val + 1);
            if (val > 2) {
                val = 0;
            }
            nbt.func_74774_a("Mode", val);
            stack.func_77982_d(nbt);
        }
    }
}

