/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.block.machine.Machine;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class MachineEnderFurnace
extends Machine {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnSlow;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnFast;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnNofuel;

    public MachineEnderFurnace(int index, int meta, String name, Class<? extends TileEntityEnderUtilities> TEClass, String tool, int harvestLevel, float hardness) {
        super(index, meta, name, TEClass, tool, harvestLevel, hardness);
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntityEnderFurnace teef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace && (teef = (TileEntityEnderFurnace)te).getOutputBufferAmount() > 0 && teef.getOutputBufferStack() != null) {
            int num;
            ItemStack stack = teef.getOutputBufferStack();
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            double xd = (float)x + f;
            double yd = (float)y + f1;
            double zd = (float)z + f2;
            int max = stack.func_77976_d();
            for (int amount = teef.getOutputBufferAmount(); amount > 0; amount -= num) {
                num = Math.min(amount, max);
                EntityItem entityitem = new EntityItem(world, xd, yd, zd, new ItemStack(stack.func_77973_b(), num, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        if (side == 3) {
            return this.iconFront;
        }
        return this.iconSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(TileEntityEnderUtilities te, int side) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        if (te != null && te instanceof TileEntityEnderFurnace && side == ((TileEntityEnderFurnace)((Object)te)).getRotation()) {
            if (!((TileEntityEnderFurnace)((Object)te)).isActive) {
                return this.iconFront;
            }
            if (((TileEntityEnderFurnace)((Object)te)).usingFuel) {
                if (((TileEntityEnderFurnace)((Object)te)).operatingMode == 1) {
                    return this.iconFrontOnFast;
                }
                return this.iconFrontOnSlow;
            }
            return this.iconFrontOnNofuel;
        }
        return this.iconSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerIcons(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".side");
        this.iconTop = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".top");
        this.iconFront = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".front.off");
        this.iconFrontOnSlow = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".front.on.slow");
        this.iconFrontOnFast = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".front.on.fast");
        this.iconFrontOnNofuel = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)"enderfurnace") + ".front.on.nofuel");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace && ((TileEntityEnderFurnace)te).isActive) {
            Particles.spawnParticlesAround(world, "portal", x, y, z, 2, rand);
        }
    }
}

