/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.machine.MachineEnderFurnace;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class Machine {
    protected static TIntObjectHashMap<Machine> machines = new TIntObjectHashMap();
    public static Machine enderFurnace = new MachineEnderFurnace(0, 0, "enderfurnace", TileEntityEnderFurnace.class, "pickaxe", 1, 6.0f);
    public static Machine toolWorkstation = new Machine(0, 1, "toolworkstation", TileEntityToolWorkstation.class, "pickaxe", 1, 6.0f);
    protected int blockIndex;
    protected int blockMeta;
    protected int machineIndex;
    protected String blockName;
    protected Class<? extends TileEntityEnderUtilities> tileEntityClass;
    protected String toolClass;
    protected int harvestLevel;
    protected float blockHardness;
    protected IIcon[] icons;

    public Machine(int index, int meta, String name, Class<? extends TileEntityEnderUtilities> TEClass, String tool, int harvestLevel, float hardness) {
        this.blockIndex = index;
        this.blockMeta = meta;
        this.machineIndex = index << 4 | meta & 0xF;
        this.blockName = name;
        this.tileEntityClass = TEClass;
        this.toolClass = tool;
        this.harvestLevel = harvestLevel;
        this.blockHardness = hardness;
        machines.put(this.machineIndex, (Object)this);
    }

    public String getBlockName() {
        return this.blockName;
    }

    public static Machine getMachine(int blockIndex, int meta) {
        return (Machine)machines.get(blockIndex << 4 | meta & 0xF);
    }

    public TileEntityEnderUtilities createNewTileEntity() {
        try {
            TileEntityEnderUtilities te = this.tileEntityClass.newInstance();
            return te;
        }
        catch (IllegalAccessException e) {
            EnderUtilities.logger.fatal("Unable to create instance of TileEntity from %s (IllegalAccessException)", new Object[]{this.tileEntityClass.getName()});
            return null;
        }
        catch (InstantiationException e) {
            EnderUtilities.logger.fatal("Unable to create instance of TileEntity from %s (InstantiationException)", new Object[]{this.tileEntityClass.getName()});
            return null;
        }
    }

    public static String[] getNames(int blockIndex) {
        String[] names = new String[16];
        for (int meta = 0; meta < 16; ++meta) {
            Machine m = Machine.getMachine(blockIndex, meta);
            if (m == null) continue;
            names[meta] = m.blockName;
        }
        return names;
    }

    public static Block setBlockHardness(Block block, int blockIndex) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m;
            if (!machines.containsKey(blockIndex << 4 | meta) || (m = (Machine)machines.get(blockIndex << 4 | meta & 0xF)) == null) continue;
            block.func_149711_c(m.blockHardness);
            break;
        }
        return block;
    }

    public static Block setBlockHarvestLevels(Block block, int blockIndex) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m;
            if (!machines.containsKey(blockIndex << 4 | meta) || (m = (Machine)machines.get(blockIndex << 4 | meta & 0xF)) == null) continue;
            block.setHarvestLevel(m.toolClass, m.harvestLevel, meta);
        }
        return block;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
    }

    @SideOnly(value=Side.CLIENT)
    public static void getSubBlocks(int blockIndex, Block block, Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 16; ++meta) {
            if (!machines.containsKey(blockIndex << 4 | meta) || machines.get(blockIndex << 4 | meta) == null) continue;
            list.add(new ItemStack(block, 1, meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        if (side == 0 || side == 1) {
            return this.icons[1];
        }
        if (side == 3) {
            return this.icons[2];
        }
        return this.icons[4];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(TileEntityEnderUtilities te, int side) {
        if (side == 0 || side == 1) {
            return this.icons[side];
        }
        if (te != null && side == te.getRotation()) {
            return this.icons[2];
        }
        return this.icons[4];
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[6];
        this.icons[0] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".bottom");
        this.icons[1] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".top");
        this.icons[2] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".front");
        this.icons[3] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".back");
        this.icons[4] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".left");
        this.icons[5] = iconRegister.func_94245_a(ReferenceTextures.getTileName((String)this.blockName) + ".right");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(int blockIndex, IIconRegister iconRegister) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m;
            if (!machines.containsKey(blockIndex << 4 | meta) || (m = (Machine)machines.get(blockIndex << 4 | meta)) == null) continue;
            m.registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }
}

