/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.init.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockEnderFurnace
extends BlockContainer {
    private final Random random = new Random();
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOff;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnSlow;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnFast;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnNofuel;

    public BlockEnderFurnace() {
        super(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(field_149780_i);
        this.func_149663_c("enderfurnace");
        this.func_149647_a(CreativeTab.ENDER_UTILITIES_TAB);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityEnderFurnace();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (rot) {
            case 0: {
                rot = 2;
                break;
            }
            case 1: {
                rot = 5;
                break;
            }
            case 2: {
                rot = 3;
                break;
            }
            case 3: {
                rot = 4;
                break;
            }
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace) {
            ((TileEntityEnderFurnace)te).setRotation((byte)rot);
            if (entity instanceof EntityPlayer) {
                ((TileEntityEnderFurnace)te).setOwner((EntityPlayer)entity);
            }
            if (stack.func_82837_s()) {
                ((TileEntityEnderFurnace)te).setInventoryName(stack.func_82833_r());
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        PlayerInteractEvent e = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, world);
        if (MinecraftForge.EVENT_BUS.post((Event)e) || e.getResult() == Event.Result.DENY || e.useBlock == Event.Result.DENY) {
            return false;
        }
        TileEntityEnderFurnace te = (TileEntityEnderFurnace)world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityEnderFurnace)) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)EnderUtilities.instance, 0, world, x, y, z);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileEntityEnderFurnace) {
            float f2;
            float f1;
            float f;
            TileEntityEnderFurnace te = (TileEntityEnderFurnace)t;
            for (int i1 = 0; i1 < te.func_70302_i_(); ++i1) {
                ItemStack itemstack = te.func_70301_a(i1);
                if (itemstack == null) continue;
                f = this.random.nextFloat() * 0.8f + 0.1f;
                f1 = this.random.nextFloat() * 0.8f + 0.1f;
                f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.random.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            if (te.getOutputBufferAmount() > 0 && te.getOutputBufferStack() != null) {
                int num;
                ItemStack stack = te.getOutputBufferStack();
                f = this.random.nextFloat() * 0.8f + 0.1f;
                f1 = this.random.nextFloat() * 0.8f + 0.1f;
                f2 = this.random.nextFloat() * 0.8f + 0.1f;
                double xd = (float)x + f;
                double yd = (float)y + f1;
                double zd = (float)z + f2;
                int max = stack.func_77976_d();
                for (int amount = te.getOutputBufferAmount(); amount > 0; amount -= num) {
                    num = Math.min(amount, max);
                    EntityItem entityitem = new EntityItem(world, xd, yd, zd, new ItemStack(stack.func_77973_b(), num, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace && ((TileEntityEnderFurnace)te).isActive) {
            Particles.spawnParticlesAround(world, "portal", x, y, z, 2, this.random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)EnderUtilitiesBlocks.enderFurnace);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        if (side == 3) {
            return this.iconFrontOff;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        byte rotation;
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace && side == (rotation = ((TileEntityEnderFurnace)te).getRotation())) {
            if (((TileEntityEnderFurnace)te).isActive) {
                if (((TileEntityEnderFurnace)te).usingFuel) {
                    if (((TileEntityEnderFurnace)te).operatingMode == 1) {
                        return this.iconFrontOnFast;
                    }
                    return this.iconFrontOnSlow;
                }
                return this.iconFrontOnNofuel;
            }
            return this.iconFrontOff;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".side");
        this.iconTop = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".top");
        this.iconFrontOff = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".front.off");
        this.iconFrontOnSlow = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".front.on.slow");
        this.iconFrontOnFast = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".front.on.fast");
        this.iconFrontOnNofuel = iconRegister.func_94245_a(Textures.getTileName("enderfurnace") + ".front.on.nofuel");
    }
}

