/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility;

import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.ENBlocks;
import exnihilo.ExNihilo;
import exnihilo.compatibility.OreList;
import exnihilo.data.ModData;
import exnihilo.registries.HeatRegistry;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class ThermalExpansion {
    public static void loadCompatibility() {
        if (ModData.OVERWRITE_DEFAULT_PULVERIZER_RECIPES) {
            ThermalExpansion.overwritePulverizerRecipe(3200, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), 10, true);
            ThermalExpansion.overwritePulverizerRecipe(3200, new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ENBlocks.Dust), 10, true);
            ExNihilo.log.info("Pulverizer: overwrote the cobble->sand recipe with cobble->gravel");
            ExNihilo.log.info("Pulverizer: added recipe for gravel->sand");
        }
        ThermalExpansion.addPulverizerRecipe(3200, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ENBlocks.Dust), null, 0, true);
        ExNihilo.log.info("Pulverizer: added recipe for sand->dust");
        Block pyrotheum = FluidRegistry.getFluid((String)"pyrotheum").getBlock();
        if (pyrotheum != null) {
            HeatRegistry.register(pyrotheum, 0.5f);
            HeatRegistry.register(pyrotheum, 0, 0.7f);
            ExNihilo.log.info("Added blazing pyrotheum as a crucible heat source");
        }
        ExNihilo.log.info("--- Thermal Expansion Integration Complete!");
    }

    public static void overwritePulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        Class<?> pulverizer = null;
        Method addRecipe = null;
        Object[] parameters = new Object[]{energy, input, primaryOutput, secondaryOutput, secondaryChance};
        try {
            pulverizer = Class.forName("thermalexpansion.util.crafting.PulverizerManager");
            if (pulverizer != null) {
                addRecipe = pulverizer.getDeclaredMethod("addTERecipe", Integer.TYPE, ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE);
                addRecipe.setAccessible(true);
            }
            if (addRecipe != null) {
                addRecipe.invoke(null, parameters);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to add pulverizer recipes, (" + ex.getMessage() + ")");
        }
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        Class<?> pulverizer = null;
        Method addRecipe = null;
        Object[] parameters = new Object[]{energy, input, primaryOutput, secondaryOutput, secondaryChance, overwrite};
        try {
            pulverizer = Class.forName("thermalexpansion.util.crafting.PulverizerManager");
            if (pulverizer != null) {
                addRecipe = pulverizer.getDeclaredMethod("addRecipe", Integer.TYPE, ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Boolean.TYPE);
                addRecipe.setAccessible(true);
            }
            if (addRecipe != null) {
                addRecipe.invoke(null, parameters);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to add pulverizer recipes, (" + ex.getMessage() + ")");
        }
    }

    public static void TryRegisterOre(String name, Block block) {
        name = name.replace("ender_", "");
        if ((name = name.replace("nether_", "")).toLowerCase().equals("iron")) {
            ThermalExpansion.RegisterOre(OreList.Type.Iron, block);
        }
        if (name.toLowerCase().equals("gold")) {
            ThermalExpansion.RegisterOre(OreList.Type.Gold, block);
        }
        if (name.toLowerCase().equals("copper")) {
            ThermalExpansion.RegisterOre(OreList.Type.Copper, block);
        }
        if (name.toLowerCase().equals("tin")) {
            ThermalExpansion.RegisterOre(OreList.Type.Tin, block);
        }
        if (name.toLowerCase().equals("nickel")) {
            ThermalExpansion.RegisterOre(OreList.Type.Nickel, block);
        }
        if (name.toLowerCase().equals("platinum")) {
            ThermalExpansion.RegisterOre(OreList.Type.Platinum, block);
        }
        if (name.toLowerCase().equals("silver")) {
            ThermalExpansion.RegisterOre(OreList.Type.Silver, block);
        }
        if (name.toLowerCase().equals("lead")) {
            ThermalExpansion.RegisterOre(OreList.Type.Lead, block);
        }
    }

    public static void RegisterOre(OreList.Type ore, Block block) {
        ItemStack iblock = new ItemStack(block);
        switch (ore) {
            case Iron: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustIron", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustNickel", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Gold: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustGold", (int)2);
                ItemStack secondary = null;
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Tin: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustTin", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustIron", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Copper: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustCopper", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustGold", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Silver: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustSilver", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustLead", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Lead: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustLead", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustSilver", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Nickel: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustNickel", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustPlatinum", (int)1);
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
            case Platinum: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustPlatinum", (int)2);
                ItemStack secondary = null;
                ThermalExpansion.addPulverizerRecipe(3200, iblock, primary, secondary, 10, true);
                break;
            }
        }
    }
}

