/*
 * Decompiled with CFR 0.152.
 */
package exnihilo;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.ENBlocks;
import exnihilo.ENItems;
import exnihilo.Entities;
import exnihilo.Fluids;
import exnihilo.Recipes;
import exnihilo.World;
import exnihilo.compatibility.AE2;
import exnihilo.compatibility.IC2;
import exnihilo.compatibility.MineFactoryReloaded;
import exnihilo.compatibility.OreList;
import exnihilo.compatibility.ThermalExpansion;
import exnihilo.compatibility.TinkersConstruct;
import exnihilo.compatibility.foresty.Forestry;
import exnihilo.data.ModData;
import exnihilo.data.WorldData;
import exnihilo.network.ENPacketHandler;
import exnihilo.proxies.Proxy;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.CompostRegistry;
import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.HeatRegistry;
import exnihilo.registries.SieveRegistry;
import java.io.File;
import net.minecraft.init.Blocks;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="exnihilo", name="Ex Nihilo", version="1.37", dependencies="required-after:Forge@[10.13.0.1180,);")
public class ExNihilo {
    @Mod.Instance(value="exnihilo")
    public static ExNihilo instance;
    @SidedProxy(clientSide="exnihilo.proxies.ClientProxy", serverSide="exnihilo.proxies.ServerProxy")
    public static Proxy proxy;
    public static Configuration config;
    public static Logger log;

    @Mod.EventHandler
    public void PreInitialize(FMLPreInitializationEvent event) {
        log = LogManager.getLogger((String)"Ex Nihilo");
        ModData.setMetadata(event.getModMetadata());
        ENPacketHandler.init();
        config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "ExNihilo.cfg"));
        config.load();
        ModData.load(config);
        WorldData.load(config);
        ENBlocks.registerBlocks();
        Fluids.registerFluids();
        Fluids.registerBuckets();
        ENItems.registerItems();
        Entities.registerEntities();
        ColorRegistry.load(config);
        CompostRegistry.load(config);
        SieveRegistry.load(config);
        CrucibleRegistry.load(config);
        HammerRegistry.load(config);
        OreList.load(config);
        if (config.hasChanged()) {
            config.save();
        }
        proxy.initializeSounds();
        proxy.initializeRenderers();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void Initialize(FMLInitializationEvent event) {
        Blocks.field_150480_ab.setFireInfo(ENBlocks.Barrel, 5, 150);
        Blocks.field_150480_ab.setFireInfo(ENBlocks.LeavesInfested, 5, 150);
        Blocks.field_150480_ab.setFireInfo(ENBlocks.Sieve, 5, 150);
        SieveRegistry.registerRewards();
        HammerRegistry.registerSmashables();
        CrucibleRegistry.registerMeltables();
        HeatRegistry.registerVanillaHeatSources();
        Recipes.registerCraftingRecipes();
        Recipes.registerFurnaceRecipes();
        World.registerWorldProviders();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"exnihilo.compatibility.Waila.callbackRegister");
    }

    @Mod.EventHandler
    public void PostInitialize(FMLPostInitializationEvent event) {
        OreList.registerOres();
        if (Loader.isModLoaded((String)"IC2")) {
            log.info("+++ - Found IC2!");
            IC2.loadCompatibility();
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            log.info("+++ - Found Forestry!");
            Forestry.loadCompatibility();
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            log.info("+++ - Found ThermalExpansion!");
            ThermalExpansion.loadCompatibility();
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            log.info("+++ - Found AE2!");
            AE2.loadCompatibility();
        }
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            log.info("+++ - Found MineFactory Reloaded!");
            MineFactoryReloaded.loadCompatibility();
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            log.info("+++ - Found Tinkers Construct!");
            TinkersConstruct.loadCompatibility();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        Fluids.registerIcons(event);
    }

    static {
        proxy = Proxy.getProxy();
    }
}

