/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasTransmitter;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class GasTransmission {
    public static TileEntity[] getConnectedTubes(TileEntity tileEntity) {
        TileEntity[] tubes = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tube = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!TransmissionType.checkTransmissionType(tube, TransmissionType.GAS, tileEntity)) continue;
            tubes[orientation.ordinal()] = tube;
        }
        return tubes;
    }

    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        IGasHandler[] acceptors = new IGasHandler[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!(acceptor instanceof IGasHandler)) continue;
            acceptors[orientation.ordinal()] = (IGasHandler)acceptor;
        }
        return acceptors;
    }

    public static ITubeConnection[] getConnections(TileEntity tileEntity) {
        ITubeConnection[] connections = new ITubeConnection[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity connection = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!GasTransmission.canConnect(connection, orientation)) continue;
            connections[orientation.ordinal()] = (ITubeConnection)connection;
        }
        return connections;
    }

    public static boolean canConnect(TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ITubeConnection && (!(tileEntity instanceof IGasTransmitter) || TransmissionType.checkTransmissionType(tileEntity, TransmissionType.GAS, tileEntity)) && ((ITubeConnection)tileEntity).canTubeConnect(side.getOpposite());
    }

    public static GasStack removeGas(ItemStack itemStack, Gas type, int amount) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)itemStack.func_77973_b();
            if (type != null && item.getGas(itemStack) != null && item.getGas(itemStack).getGas() != type || !item.canProvideGas(itemStack, type)) {
                return null;
            }
            return item.removeGas(itemStack, amount);
        }
        return null;
    }

    public static int addGas(ItemStack itemStack, GasStack stack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem && ((IGasItem)itemStack.func_77973_b()).canReceiveGas(itemStack, stack.getGas())) {
            return ((IGasItem)itemStack.func_77973_b()).addGas(itemStack, stack.copy());
        }
        return 0;
    }
}

