/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import java.util.Collection;
import java.util.Iterator;

public class VertexTransformComposite
implements VertexTransform {
    private final VertexTransform[] xforms;

    public VertexTransformComposite(VertexTransform ... xforms) {
        this.xforms = xforms;
    }

    VertexTransformComposite(Collection<VertexTransform> xformsIn) {
        this.xforms = new VertexTransform[xformsIn.size()];
        int i = 0;
        Iterator<VertexTransform> i$ = xformsIn.iterator();
        while (i$.hasNext()) {
            VertexTransform xform;
            this.xforms[i] = xform = i$.next();
            ++i;
        }
    }

    @Override
    public void apply(Vertex vertex) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vertex);
        }
    }

    @Override
    public void apply(Vector3d vec) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vec);
        }
    }

    @Override
    public void applyToNormal(Vector3f vec) {
        for (VertexTransform xform : this.xforms) {
            xform.applyToNormal(vec);
        }
    }
}

