/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.waila;

import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.block.BlockDarkSteelAnvil;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.enderio.waila.IWailaNBTProvider;
import crazypants.util.Lang;
import info.jbcs.minecraft.chisel.api.IFacade;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WailaCompat
implements IWailaDataProvider {
    public static final WailaCompat INSTANCE = new WailaCompat();
    private static IWailaDataAccessor _accessor = null;

    public static void load(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, IFacade.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockDarkSteelAnvil.class);
        registrar.registerHeadProvider((IWailaDataProvider)INSTANCE, Block.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, Block.class);
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, Block.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, TileEntityEio.class);
        registrar.registerSyncedNBTKey("controllerStoredEnergyRF", TileCapacitorBank.class);
        ConfigHandler.instance().addConfig("Ender IO", "facades.hidden", "Sneaky Facades");
        IWailaInfoProvider.fmt.setMaximumFractionDigits(1);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition pos = accessor.getPosition();
        if (config.getConfig("facades.hidden")) {
            IFacade bundle;
            Block facade;
            if (accessor.getBlock() instanceof IFacade && (facade = (bundle = (IFacade)accessor.getBlock()).getFacade((IBlockAccess)accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, accessor.getSide().ordinal())) != null) {
                ItemStack ret = facade.getPickBlock(pos, accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                return ret;
            }
        } else if (accessor.getBlock() instanceof BlockDarkSteelAnvil) {
            return accessor.getBlock().getPickBlock(accessor.getPosition(), accessor.getWorld(), accessor.getPosition().field_72311_b, accessor.getPosition().field_72312_c, accessor.getPosition().field_72309_d);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        _accessor = accessor;
        Block block = accessor.getBlock();
        TileEntity te = accessor.getTileEntity();
        Item item = Item.func_150898_a((Block)block);
        EntityPlayer player = accessor.getPlayer();
        World world = player.field_70170_p;
        MovingObjectPosition pos = accessor.getPosition();
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        if (te instanceof IIoConfigurable) {
            IIoConfigurable machine = (IIoConfigurable)te;
            ForgeDirection side = accessor.getSide();
            IoMode mode = machine.getIoMode(side);
            currenttip.add(EnumChatFormatting.YELLOW + String.format(Lang.localize("gui.machine.side"), EnumChatFormatting.WHITE + Lang.localize("gui.machine.side." + side.name().toLowerCase())));
            currenttip.add(EnumChatFormatting.YELLOW + String.format(Lang.localize("gui.machine.ioMode"), mode.colorLocalisedName()));
        }
        if (block instanceof IWailaInfoProvider) {
            IWailaInfoProvider info = (IWailaInfoProvider)block;
            if (block instanceof IAdvancedTooltipProvider) {
                int mask = info.getDefaultDisplayMask(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                boolean basic = (mask & 1) == 1;
                boolean common = (mask & 2) == 2;
                boolean detailed = (mask & 4) == 4;
                IAdvancedTooltipProvider adv = (IAdvancedTooltipProvider)block;
                if (common) {
                    adv.addCommonEntries(itemStack, player, currenttip, false);
                }
                if (TooltipAddera.showAdvancedTooltips() && detailed) {
                    adv.addDetailedEntries(itemStack, player, currenttip, false);
                } else if (detailed) {
                    TooltipAddera.addShowDetailsTooltip(currenttip);
                }
                if (!TooltipAddera.showAdvancedTooltips() && basic) {
                    adv.addBasicEntries(itemStack, player, currenttip, false);
                }
            } else if (block instanceof IResourceTooltipProvider) {
                TooltipAddera.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
            }
            if (currenttip.size() > 0) {
                currenttip.add("");
            }
            info.getWailaInfo(currenttip, player, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        } else if (block instanceof IAdvancedTooltipProvider) {
            TooltipAddera.addInformation((IAdvancedTooltipProvider)block, itemStack, player, currenttip, false);
        } else if (item instanceof IAdvancedTooltipProvider) {
            TooltipAddera.addInformation((IAdvancedTooltipProvider)item, itemStack, player, currenttip, false);
        } else if (block instanceof IResourceTooltipProvider) {
            TooltipAddera.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
        }
        if (te instanceof IInternalPoweredTile && accessor.getNBTData().func_74764_b("storedEnergyRF") && !(te instanceof TileCapBank)) {
            IInternalPoweredTile power = (IInternalPoweredTile)te;
            if (power.displayPower()) {
                if (currenttip.size() > 4) {
                    currenttip.add("");
                }
                int stored = accessor.getTileEntity() instanceof TileCapacitorBank ? power.getEnergyStored() : accessor.getNBTData().func_74762_e("storedEnergyRF");
                int max = power.getMaxEnergyStored();
                currenttip.add(String.format("%s%s%s / %s%s%s RF", EnumChatFormatting.WHITE, IWailaInfoProvider.fmt.format(stored), EnumChatFormatting.RESET, EnumChatFormatting.WHITE, IWailaInfoProvider.fmt.format(max), EnumChatFormatting.RESET));
            }
        } else if (te instanceof IConduitBundle && itemStack != null && itemStack.func_77973_b() == EnderIO.itemPowerConduit) {
            NBTTagCompound nbtRoot = accessor.getNBTData();
            short nbtVersion = nbtRoot.func_74765_d("nbtVersion");
            NBTTagList conduitTags = (NBTTagList)nbtRoot.func_74781_a("conduits");
            if (conduitTags != null) {
                for (int i = 0; i < conduitTags.func_74745_c(); ++i) {
                    NBTTagCompound conduitTag = conduitTags.func_150305_b(i);
                    IConduit conduit = ConduitUtil.readConduitFromNBT(conduitTag, nbtVersion);
                    if (conduit == null || !(conduit instanceof IPowerConduit)) continue;
                    currenttip.add(String.format("%s%s%s / %s%s%s RF", EnumChatFormatting.WHITE, IWailaInfoProvider.fmt.format(((IPowerConduit)conduit).getEnergyStored()), EnumChatFormatting.RESET, EnumChatFormatting.WHITE, IWailaInfoProvider.fmt.format(((IConduitBundle)te).getMaxEnergyStored()), EnumChatFormatting.RESET));
                }
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof IWailaNBTProvider) {
            ((IWailaNBTProvider)te).getData(tag);
        }
        tag.func_74768_a("x", x);
        tag.func_74768_a("y", y);
        tag.func_74768_a("z", z);
        return tag;
    }

    public static NBTTagCompound getNBTData() {
        return _accessor.getNBTData();
    }
}

