/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.BlockFusedQuartz;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.OreDictionaryPreferences;
import crazypants.enderio.material.PowderIngot;
import crazypants.util.OreDictionaryHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class MaterialRecipes {
    public static void registerDependantOresInDictionary() {
        if (OreDictionaryHelper.hasCopper()) {
            OreDictionary.registerOre((String)"dustCopper", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COPPER.ordinal()));
        }
        if (OreDictionaryHelper.hasTin()) {
            OreDictionary.registerOre((String)"dustTin", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_TIN.ordinal()));
        }
        if (OreDictionaryHelper.hasEnderPearlDust()) {
            OreDictionary.registerOre((String)"dustEnderPearl", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_ENDER.ordinal()));
        }
        if (OreDictionaryHelper.hasEnderium()) {
            OreDictionary.registerOre((String)"ingotEnderiumBase", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.INGOT_ENDERIUM_BASE.ordinal()));
        }
    }

    public static void registerOresInDictionary() {
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COAL.ordinal()));
        OreDictionary.registerOre((String)"dustIron", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_IRON.ordinal()));
        OreDictionary.registerOre((String)"dustGold", (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_GOLD.ordinal()));
        OreDictionary.registerOre((String)"gearStone", (ItemStack)new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.BASIC_GEAR.ordinal()));
        OreDictionary.registerOre((String)"itemSilicon", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.SILICON.ordinal()));
        for (Alloy alloy : Alloy.values()) {
            OreDictionary.registerOre((String)alloy.oredictIngotName, (ItemStack)new ItemStack((Item)EnderIO.itemAlloy, 1, alloy.ordinal()));
            OreDictionary.registerOre((String)alloy.oredictBlockName, (ItemStack)new ItemStack((Block)EnderIO.blockIngotStorage, 1, alloy.ordinal()));
        }
        OreDictionary.registerOre((String)"nuggetPulsatingIron", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PHASED_IRON_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetVibrantAlloy", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"glass", (Block)Blocks.field_150359_w);
        OreDictionary.registerOre((String)"stickWood", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"woodStick", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingotIron", (Item)Items.field_151042_j);
        OreDictionary.registerOre((String)"ingotGold", (Item)Items.field_151043_k);
        ItemStack pureGlass = new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.GLASS.ordinal());
        OreDictionary.registerOre((String)"glass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.FUSED_QUARTZ.ordinal()));
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)skull);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack((Block)EnderIO.blockEndermanSkull));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150410_aZ, 16, 0), (Object[])new Object[]{"   ", "eee", "eee", Character.valueOf('e'), pureGlass});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150359_w), (Object[])new Object[]{pureGlass});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151069_bo, 3, 0), (Object[])new Object[]{"   ", "g g", " g ", Character.valueOf('g'), pureGlass});
    }

    public static void addRecipes() {
        ItemStack conduitBinder = new ItemStack((Item)EnderIO.itemMaterial, 4, Material.CONDUIT_BINDER.ordinal());
        ItemStack basicGear = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.BASIC_GEAR.ordinal());
        ItemStack binderComposite = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.BINDER_COMPOSITE.ordinal());
        ItemStack fusedQuartzFrame = new ItemStack((Item)EnderIO.itemFusedQuartzFrame, 1, 0);
        ItemStack machineChassi = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.MACHINE_CHASSI.ordinal());
        ItemStack phasedGold = new ItemStack((Item)EnderIO.itemAlloy, 1, Alloy.PHASED_GOLD.ordinal());
        ItemStack phasedIron = new ItemStack((Item)EnderIO.itemAlloy, 1, Alloy.PHASED_IRON.ordinal());
        ItemStack electricalSteel = new ItemStack((Item)EnderIO.itemAlloy, 1, Alloy.ELECTRICAL_STEEL.ordinal());
        ItemStack darkSteel = new ItemStack((Item)EnderIO.itemAlloy, 1, Alloy.DARK_STEEL.ordinal());
        ItemStack capacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 0);
        ItemStack cbc = binderComposite.func_77946_l();
        cbc.field_77994_a = 8;
        if (Config.useAlternateBinderRecipe) {
            GameRegistry.addShapedRecipe((ItemStack)cbc, (Object[])new Object[]{"gcg", "sgs", "gcg", Character.valueOf('g'), Blocks.field_150351_n, Character.valueOf('s'), Blocks.field_150354_m, Character.valueOf('c'), Items.field_151119_aD});
        } else {
            GameRegistry.addShapedRecipe((ItemStack)cbc, (Object[])new Object[]{"ggg", "scs", "ggg", Character.valueOf('g'), Blocks.field_150351_n, Character.valueOf('s'), Blocks.field_150354_m, Character.valueOf('c'), Items.field_151119_aD});
        }
        FurnaceRecipes.func_77602_a().func_151394_a(binderComposite, conduitBinder, 0.0f);
        ItemStack phasedIronNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.PHASED_IRON_NUGGET.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)phasedIronNugget, (Object[])new Object[]{phasedIron});
        phasedIronNugget = phasedIronNugget.func_77946_l();
        phasedIronNugget.field_77994_a = 1;
        GameRegistry.addShapedRecipe((ItemStack)phasedIron, (Object[])new Object[]{"eee", "eee", "eee", Character.valueOf('e'), phasedIronNugget});
        ItemStack vibrantNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.VIBRANT_NUGGET.ordinal());
        GameRegistry.addShapelessRecipe((ItemStack)vibrantNugget, (Object[])new Object[]{phasedGold});
        vibrantNugget = vibrantNugget.func_77946_l();
        vibrantNugget.field_77994_a = 1;
        GameRegistry.addShapedRecipe((ItemStack)phasedGold, (Object[])new Object[]{"eee", "eee", "eee", Character.valueOf('e'), vibrantNugget});
        ItemStack pulsCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PULSATING_CYSTAL.ordinal());
        GameRegistry.addShapedRecipe((ItemStack)pulsCry, (Object[])new Object[]{"nnn", "ngn", "nnn", Character.valueOf('n'), phasedIronNugget, Character.valueOf('g'), Items.field_151045_i});
        ItemStack vibCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_CYSTAL.ordinal());
        GameRegistry.addShapedRecipe((ItemStack)vibCry, (Object[])new Object[]{"nnn", "ngn", "nnn", Character.valueOf('n'), vibrantNugget, Character.valueOf('g'), Items.field_151166_bC});
        ItemStack darkBall = new ItemStack((Item)EnderIO.itemMaterial, 5, Material.DRAK_GRINDING_BALL.ordinal());
        GameRegistry.addShapedRecipe((ItemStack)darkBall, (Object[])new Object[]{" s ", "sss", " s ", Character.valueOf('s'), darkSteel});
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_IRON.ordinal()), new ItemStack(Items.field_151042_j), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_GOLD.ordinal()), new ItemStack(Items.field_151043_k), 0.0f);
        ItemStack enderDust = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_ENDER.ordinal());
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151079_bi), (Object[])new Object[]{"eee", "eee", "eee", Character.valueOf('e'), enderDust});
        ItemStack diBars = new ItemStack((Block)EnderIO.blockDarkIronBars, 16, 0);
        GameRegistry.addShapedRecipe((ItemStack)diBars, (Object[])new Object[]{"ddd", "ddd", Character.valueOf('d'), darkSteel});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fusedQuartzFrame, new Object[]{"bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fusedQuartzFrame, new Object[]{"bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "woodStick"}));
        ArrayList steelIngots = OreDictionary.getOres((String)"ingotSteel");
        if (Config.useSteelInChassi && steelIngots != null && !steelIngots.isEmpty()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineChassi, new Object[]{"fif", "ici", "fif", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), "ingotSteel", Character.valueOf('c'), capacitor}));
        } else {
            GameRegistry.addShapedRecipe((ItemStack)machineChassi, (Object[])new Object[]{"fif", "ici", "fif", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), capacitor});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(basicGear, new Object[]{"scs", "c c", "scs", Character.valueOf('s'), "stickWood", Character.valueOf('c'), Blocks.field_150347_e}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(basicGear, new Object[]{"scs", "c c", "scs", Character.valueOf('s'), "woodStick", Character.valueOf('c'), Blocks.field_150347_e}));
        ItemStack enderCapacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 2);
        ItemStack activatedCapacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 1);
        if (Config.useHardRecipes) {
            GameRegistry.addShapedRecipe((ItemStack)enderCapacitor, (Object[])new Object[]{"eee", "cgc", "eee", Character.valueOf('e'), phasedGold, Character.valueOf('c'), activatedCapacitor, Character.valueOf('g'), Blocks.field_150426_aN});
        } else {
            GameRegistry.addShapedRecipe((ItemStack)enderCapacitor, (Object[])new Object[]{" e ", "cgc", " e ", Character.valueOf('e'), phasedGold, Character.valueOf('c'), activatedCapacitor, Character.valueOf('g'), Blocks.field_150426_aN});
        }
        if (Config.reinforcedObsidianEnabled) {
            ItemStack reinfObs = new ItemStack((Block)EnderIO.blockReinforcedObsidian);
            ItemStack corners = darkSteel;
            if (Config.reinforcedObsidianUseDarkSteelBlocks) {
                corners = new ItemStack((Block)EnderIO.blockIngotStorage, 1, Alloy.DARK_STEEL.ordinal());
            }
            GameRegistry.addShapedRecipe((ItemStack)reinfObs, (Object[])new Object[]{"dbd", "bob", "dbd", Character.valueOf('d'), corners, Character.valueOf('b'), EnderIO.blockDarkIronBars, Character.valueOf('o'), Blocks.field_150343_Z});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)EnderIO.blockDarkSteelAnvil, new Object[]{"bbb", " i ", "iii", Character.valueOf('b'), "blockDarkSteel", Character.valueOf('i'), "ingotDarkSteel"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)EnderIO.blockDarkSteelLadder, 12), (Object[])new Object[]{"b", "b", "b", Character.valueOf('b'), EnderIO.blockDarkIronBars});
        for (Alloy alloy : Alloy.values()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)EnderIO.blockIngotStorage, 1, alloy.ordinal()), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), alloy.oredictIngotName}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)EnderIO.itemAlloy, 9, alloy.ordinal()), (Object[])new Object[]{new ItemStack((Block)EnderIO.blockIngotStorage, 1, alloy.ordinal())});
        }
    }

    public static void addOreDictionaryRecipes() {
        if (OreDictionaryHelper.hasCopper()) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COPPER.ordinal()), OreDictionaryPreferences.instance.getPreferred("ingotCopper"), 0.0f);
        }
        if (OreDictionaryHelper.hasTin()) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_TIN.ordinal()), OreDictionaryPreferences.instance.getPreferred("ingotTin"), 0.0f);
        }
        ItemStack capacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 0);
        ArrayList copperIngots = OreDictionary.getOres((String)"ingotCopper");
        Item gold = Config.useHardRecipes ? Items.field_151043_k : Items.field_151074_bl;
        if (copperIngots != null && !copperIngots.isEmpty() && Config.useModMetals) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(capacitor, new Object[]{" gr", "gcg", "rg ", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), gold, Character.valueOf('c'), "ingotCopper"}));
        } else {
            GameRegistry.addShapedRecipe((ItemStack)capacitor, (Object[])new Object[]{" gr", "gig", "rg ", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), gold, Character.valueOf('i'), Items.field_151042_j});
        }
        int dustCoal = OreDictionary.getOreID((String)"dustCoal");
        ItemStack activatedCapacitor = new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 1);
        ItemStack energeticAlloy = new ItemStack((Item)EnderIO.itemAlloy, 1, Alloy.ENERGETIC_ALLOY.ordinal());
        if (Config.useHardRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(activatedCapacitor, new Object[]{"eee", "cCc", "eee", Character.valueOf('e'), energeticAlloy, Character.valueOf('c'), capacitor, Character.valueOf('C'), "dustCoal"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(activatedCapacitor, new Object[]{" e ", "cCc", " e ", Character.valueOf('e'), energeticAlloy, Character.valueOf('c'), capacitor, Character.valueOf('C'), "dustCoal"}));
        }
    }
}

