/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.material.BlockFusedQuartz;
import crazypants.render.ConnectedTextureRenderer;
import crazypants.render.CustomCubeRenderer;
import crazypants.render.RenderUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class FusedQuartzRenderer
implements ISimpleBlockRenderingHandler {
    static int renderPass;
    private ConnectedTextureRenderer connectedTextureRenderer = new ConnectedTextureRenderer(){

        @Override
        public boolean matchesMetadata(int meta1, int meta2) {
            if (super.matchesMetadata(meta1, meta2)) {
                return true;
            }
            BlockFusedQuartz.Type type = BlockFusedQuartz.Type.values()[meta1];
            return type.connectTo(meta2);
        }
    };

    public FusedQuartzRenderer() {
        this.connectedTextureRenderer.setMatchMeta(!Config.clearGlassConnectToFusedQuartz);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_147757_a(EnderIO.blockFusedQuartz.getItemIcon(metadata));
        renderer.func_147800_a(Blocks.field_150359_w, 0, 1.0f);
        renderer.func_147771_a();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockFusedQuartz.renderId;
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = blockAccess.func_72805_g(x, y, z);
        TileEntityPaintedBlock tecb = null;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            tecb = (TileEntityPaintedBlock)te;
        }
        this.renderFrame(blockAccess, x, y, z, tecb, false, meta);
        return true;
    }

    public void renderFrameItem(ItemStack stack) {
        RenderUtil.bindBlockTexture();
        Tessellator.field_78398_a.func_78382_b();
        TileEntityPaintedBlock tecb = new TileEntityPaintedBlock();
        tecb.setSourceBlock(PainterUtil.getSourceBlock(stack));
        tecb.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        this.renderFrame(null, 0, 0, 0, tecb, true, stack.func_77960_j());
        Tessellator.field_78398_a.func_78381_a();
    }

    private void renderFrame(IBlockAccess blockAccess, int x, int y, int z, TileEntityPaintedBlock tecb, boolean forceAllEdges, int meta) {
        if (blockAccess == null) {
            IIcon texture = EnderIO.blockFusedQuartz.getItemIcon(meta);
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                if (tecb != null && tecb.getSourceBlock() != null) {
                    texture = tecb.getSourceBlock().func_149691_a(face.ordinal(), tecb.getSourceBlockMetadata());
                }
                RenderUtil.renderConnectedTextureFace(blockAccess, EnderIO.blockFusedQuartz, x, y, z, face, texture, forceAllEdges);
            }
            return;
        }
        CustomCubeRenderer.instance.setOverrideTexture(EnderIO.blockFusedQuartz.func_149691_a(0, meta));
        if (tecb != null && tecb.getSourceBlock() != null) {
            this.connectedTextureRenderer.setEdgeTexureCallback(new ConnectedTextureRenderer.DefaultTextureCallback(tecb.getSourceBlock(), tecb.getSourceBlockMetadata()));
            CustomCubeRenderer.instance.renderBlock(blockAccess, (Block)EnderIO.blockFusedQuartz, x, y, z, this.connectedTextureRenderer);
        } else {
            this.connectedTextureRenderer.setEdgeTexture(EnderIO.blockFusedQuartz.getDefaultFrameIcon(meta));
            CustomCubeRenderer.instance.renderBlock(blockAccess, (Block)EnderIO.blockFusedQuartz, x, y, z, this.connectedTextureRenderer);
        }
        CustomCubeRenderer.instance.setOverrideTexture(null);
    }
}

