/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.gui.item.BasicItemFilterGui;
import crazypants.enderio.conduit.gui.item.IItemFilterContainer;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.gui.ITabPanel;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.transceiver.PacketItemFilter;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class FilterTab
implements ITabPanel {
    GuiTransceiver parent;
    ContainerTransceiver container;
    BasicItemFilterGui sendGui;
    BasicItemFilterGui recGui;
    IconButtonEIO sendRecB;
    boolean showSend = true;

    FilterTab(GuiTransceiver parent) {
        this.parent = parent;
        this.container = parent.getContainer();
        this.sendGui = new BasicItemFilterGui(parent, new FilterContainer(parent.getTransciever(), true), false, this.container.getFilterOffset().x, this.container.getFilterOffset().y, 0);
        this.recGui = new BasicItemFilterGui(parent, new FilterContainer(parent.getTransciever(), true), false, this.container.getFilterOffset().x, this.container.getFilterOffset().y, 20);
        this.sendRecB = new IconButtonEIO(parent, 8888, this.container.getFilterOffset().x + 79, this.container.getFilterOffset().y - 20, IconEIO.RIGHT_ARROW);
        this.sendRecB.setSize(10, 16);
    }

    @Override
    public void onGuiInit(int x, int y, int width, int height) {
        this.parent.getContainer().setPlayerInventoryVisible(true);
        this.sendRecB.onGuiInit();
        this.updateSendRecieve();
    }

    protected void updateSendRecieve() {
        if (this.showSend) {
            this.parent.getContainer().setSendFilterSlotsVisible(true);
            this.parent.getContainer().setReceiveFilterSlotsVisible(false);
            this.sendGui.updateButtons();
            this.recGui.deactivate();
        } else {
            this.parent.getContainer().setSendFilterSlotsVisible(false);
            this.parent.getContainer().setReceiveFilterSlotsVisible(true);
            this.sendGui.deactivate();
            this.recGui.updateButtons();
        }
    }

    @Override
    public void deactivate() {
        this.parent.getContainer().setPlayerInventoryVisible(false);
        this.parent.getContainer().setSendFilterSlotsVisible(false);
        this.parent.getContainer().setReceiveFilterSlotsVisible(false);
        this.sendGui.deactivate();
        this.recGui.deactivate();
        this.sendRecB.detach();
    }

    @Override
    public IconEIO getIcon() {
        return IconEIO.FILTER;
    }

    @Override
    public void render(float par1, int par2, int par3) {
        int top = this.parent.getGuiTop();
        int left = this.parent.getGuiLeft();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/transceiver.png");
        Point invRoot = this.container.getPlayerInventoryOffset();
        this.parent.func_73729_b(left + invRoot.x - 1, top + invRoot.y - 1, 24, 180, 162, 76);
        if (this.showSend) {
            this.sendGui.renderCustomOptions(0, par1, par2, par3);
        } else {
            this.recGui.renderCustomOptions(0, par1, par2, par3);
        }
        String txt = "Send Filter";
        if (!this.showSend) {
            txt = "Receive Filter";
        }
        FontRenderer fr = this.parent.getFontRenderer();
        int x = left + this.container.getFilterOffset().x;
        int y = top - fr.field_78288_b + this.container.getFilterOffset().y - 7;
        fr.func_78261_a(txt, x, y, ColorUtil.getRGB(Color.WHITE));
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton == this.sendRecB) {
            this.showSend = !this.showSend;
            this.updateSendRecieve();
        }
        if (this.showSend) {
            this.sendGui.actionPerformed(guiButton);
        } else {
            this.recGui.actionPerformed(guiButton);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        if (this.showSend) {
            this.sendGui.mouseClicked(x, y, par3);
        } else {
            this.recGui.mouseClicked(x, y, par3);
        }
    }

    @Override
    public void keyTyped(char par1, int par2) {
    }

    @Override
    public void updateScreen() {
    }

    private static class FilterContainer
    implements IItemFilterContainer {
        private TileTransceiver trans;
        private boolean isSend;

        private FilterContainer(TileTransceiver trans, boolean isSend) {
            this.trans = trans;
            this.isSend = isSend;
        }

        @Override
        public ItemFilter getItemFilter() {
            if (this.isSend) {
                return this.trans.getSendItemFilter();
            }
            return this.trans.getReceiveItemFilter();
        }

        @Override
        public void onFilterChanged() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemFilter(this.trans, this.isSend));
        }
    }
}

