/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import crazypants.util.FluidUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSoulBinder
extends AbstractPoweredTaskEntity
implements IHaveExperience,
IFluidHandler {
    public static final int POWER_PER_TICK_ONE = Config.soulBinderLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor(POWER_PER_TICK_ONE * 2, Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_ONE);
    public static final int POWER_PER_TICK_TWO = Config.soulBinderLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor(POWER_PER_TICK_TWO * 2, Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_TWO);
    public static final int POWER_PER_TICK_THREE = Config.soulBinderLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor(POWER_PER_TICK_THREE * 2, Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_THREE);
    private ICapacitor capacitor;
    private ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.soulBinderMaxXpLevel));

    public TileSoulBinder() {
        super(new SlotDefinition(2, 2, 1));
        this.capacitor = CAP_ONE;
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSoulBinder.unlocalisedName;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround(new PacketExperianceContainer(this), this);
            this.xpCont.setDirty(false);
        }
        return super.processTasks(redstoneChecksPassed);
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe recipe = super.canStartNextTask(chance);
        if (recipe == null) {
            return null;
        }
        int xpRequired = ((ISoulBinderRecipe)((Object)recipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() >= xpRequired) {
            return recipe;
        }
        return null;
    }

    public int getCurrentlyRequiredLevel() {
        if (this.currentTask != null) {
            return -1;
        }
        IMachineRecipe nextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), this.getRecipeInputs());
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return -1;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        int xpRequired = ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
        if (this.xpCont.getExperienceLevel() < xpRequired) {
            return false;
        }
        if (super.startNextTask(nextRecipe, chance)) {
            this.xpCont.drain(ForgeDirection.UNKNOWN, XpUtil.getLiquidForLevel(xpRequired), true);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack item) {
        int otherSlot;
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        MachineRecipeInput newInput = new MachineRecipeInput(slot, item);
        int n = otherSlot = slot == 0 ? 1 : 0;
        if (this.inventory[otherSlot] == null) {
            List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), newInput);
            if (recipes.isEmpty()) {
                return false;
            }
            for (IMachineRecipe rec : recipes) {
                if (rec == null || !rec.isValidInput(newInput)) continue;
                return true;
            }
        } else {
            MachineRecipeInput[] inputs = new MachineRecipeInput[]{newInput, new MachineRecipeInput(otherSlot, this.inventory[otherSlot])};
            return MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), inputs) != null;
        }
        return false;
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        switch (capacitorType) {
            case BASIC_CAPACITOR: {
                this.capacitor = CAP_ONE;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.capacitor = CAP_TWO;
                break;
            }
            case ENDER_CAPACITOR: {
                this.capacitor = CAP_THREE;
                break;
            }
            default: {
                this.capacitor = CAP_ONE;
            }
        }
        super.setCapacitor(capacitorType);
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    @Override
    public int getPowerUsePerTick() {
        if (this.capacitorType.ordinal() == 0) {
            return POWER_PER_TICK_ONE;
        }
        if (this.capacitorType.ordinal() == 1) {
            return POWER_PER_TICK_TWO;
        }
        return POWER_PER_TICK_THREE;
    }

    @Override
    public int getProgressScaled(int scale) {
        int res = super.getProgressScaled(scale);
        if (this.currentTask != null) {
            res = Math.max(1, res);
        }
        return res;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull(this, dir, Config.fluidConduitExtractRate);
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        boolean res = super.doPush(dir);
        FluidUtil.doPush(this, dir, Config.fluidConduitExtractRate);
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canFill(from, fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.xpCont.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.xpCont.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCont.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.xpCont.getTankInfo(from);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.xpCont.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.xpCont.writeToNBT(nbtRoot);
    }
}

