/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.soul.BlockSoulBinder;
import crazypants.enderio.machine.soul.TileSoulBinder;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.IconUtil;
import crazypants.util.ForgeDirectionOffsets;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SoulBinderRenderer
implements ISimpleBlockRenderingHandler {
    private IIcon soulariumIcon;
    private IIcon darkSteelIcon;
    private float skullScale = 0.5f;
    private BoundingBox scaledBB = BoundingBox.UNIT_CUBE.scale(this.skullScale, this.skullScale, this.skullScale);
    private IIcon[] icons = new IIcon[6];

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        Tessellator.field_78398_a.func_78382_b();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon endermanIcon;
        if (this.soulariumIcon == null) {
            this.soulariumIcon = EnderIO.blockSoulFuser.func_149691_a(ForgeDirection.EAST.ordinal(), 0);
        }
        if (renderer != null && world != null) {
            renderer.func_147757_a(IconUtil.blankTexture);
            renderer.func_147784_q(Blocks.field_150348_b, x, y, z);
            renderer.func_147757_a(null);
        }
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.85, 0.85);
        this.setIcons(this.soulariumIcon, ForgeDirection.NORTH);
        CubeRenderer.render(bb, this.icons, true);
        float slabWidth = 0.15f;
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, slabWidth, 1.0f);
        bb = bb.translate(0.0f, 0.5f - slabWidth / 2.0f, 0.0f);
        this.setIcons(EnderIO.blockSoulFuser.func_149691_a(ForgeDirection.UP.ordinal(), 0), ForgeDirection.UP);
        CubeRenderer.render(bb, this.icons, true);
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, slabWidth, 1.0f);
        bb = bb.translate(0.0f, -0.5f + slabWidth / 2.0f, 0.0f);
        this.setIcons(this.soulariumIcon, ForgeDirection.NORTH);
        CubeRenderer.render(bb, this.icons, true);
        int facing = ForgeDirection.SOUTH.ordinal();
        if (world == null || !(world.func_147438_o(x, y, z) instanceof TileSoulBinder)) {
            endermanIcon = EnderIO.blockSoulFuser.endermanSkullIcon;
        } else {
            TileSoulBinder sb = (TileSoulBinder)world.func_147438_o(x, y, z);
            facing = sb.facing;
            endermanIcon = sb.isActive() ? EnderIO.blockSoulFuser.endermanSkullIconOn : EnderIO.blockSoulFuser.endermanSkullIcon;
        }
        this.renderSkull(this.forFacing(ForgeDirection.SOUTH, facing), endermanIcon);
        this.renderSkull(this.forFacing(ForgeDirection.WEST, facing), EnderIO.blockSoulFuser.skeletonSkullIcon);
        this.renderSkull(this.forFacing(ForgeDirection.NORTH, facing), EnderIO.blockSoulFuser.zombieSkullIcon);
        this.renderSkull(this.forFacing(ForgeDirection.EAST, facing), EnderIO.blockSoulFuser.creeperSkullIcon);
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    private ForgeDirection forFacing(ForgeDirection side, int facing) {
        return ForgeDirection.values()[ClientProxy.sideAndFacingToSpriteOffset[side.ordinal()][facing]];
    }

    private void renderSkull(ForgeDirection face, IIcon faceIcon) {
        BoundingBox bb = this.scaledBB.translate(ForgeDirectionOffsets.offsetScaled(face, 0.5 - (double)(this.skullScale / 2.0f)));
        this.setIcons(faceIcon, face);
        CubeRenderer.render(bb, this.icons, true);
    }

    private void setIcons(IIcon faceIcon, ForgeDirection faceSide) {
        this.setIcons(this.soulariumIcon, faceIcon, faceSide);
    }

    private void setIcons(IIcon defaultIcon, IIcon faceIcon, ForgeDirection faceSide) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.icons[dir.ordinal()] = dir == faceSide ? faceIcon : defaultIcon;
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockSoulBinder.renderId;
    }
}

