/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import crazypants.util.Util;
import crazypants.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockReservoir
extends BlockContainer
implements IResourceTooltipProvider {
    private IIcon[] mbIcons = new IIcon[8];
    IIcon switchIcon;

    public static BlockReservoir create() {
        BlockReservoir result = new BlockReservoir();
        result.init();
        return result;
    }

    private BlockReservoir() {
        super(Material.field_151576_e);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(ModObject.blockReservoir.unlocalisedName);
        this.func_149647_a(EnderIOTab.tabEnderIO);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileReservoir();
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, (String)ModObject.blockReservoir.unlocalisedName);
        GameRegistry.registerTileEntity(TileReservoir.class, (String)(ModObject.blockReservoir.unlocalisedName + "TileEntity"));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        ItemStack current = entityPlayer.field_71071_by.func_70448_g();
        if (current != null) {
            TileReservoir tank = (TileReservoir)world.func_147438_o(x, y, z);
            FluidStack liquid = FluidUtil.getFluidFromItem(current);
            if (liquid != null) {
                int qty = tank.getController().doFill(ForgeDirection.UNKNOWN, liquid, true);
                if (qty != 0 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(current));
                }
                return true;
            }
            FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && available.amount > 0) {
                ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current);
                if (current.func_77973_b() == Items.field_151133_ar) {
                    filled = new ItemStack(Items.field_151131_as);
                }
                liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
                if (current.func_77973_b() == Items.field_151133_ar) {
                    liquid = new FluidStack(FluidRegistry.WATER, 1000);
                }
                if (liquid != null) {
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityPlayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(current));
                        } else {
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(current));
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                    return true;
                }
                if (ToolUtil.isToolEquipped(entityPlayer) && tank.isMultiblock()) {
                    tank.setAutoEject(!tank.isAutoEject());
                    for (BlockCoord bc : tank.multiblock) {
                        world.func_147471_g(bc.x, bc.y, bc.z);
                    }
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return super.func_149633_g(world, x, y, z);
        }
        TileReservoir tr = (TileReservoir)te;
        if (!tr.isMultiblock()) {
            return super.func_149633_g(world, x, y, z);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (BlockCoord bc : tr.multiblock) {
            min.x = Math.min(min.x, (double)bc.x);
            max.x = Math.max(max.x, (double)(bc.x + 1));
            min.y = Math.min(min.y, (double)bc.y);
            max.y = Math.max(max.y, (double)(bc.y + 1));
            min.z = Math.min(min.z, (double)bc.z);
            max.z = Math.max(max.z, (double)(bc.z + 1));
        }
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileReservoir();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        TileReservoir tr = (TileReservoir)world.func_147438_o(x, y, z);
        boolean res = tr.onBlockAdded();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileReservoir) {
            ((TileReservoir)te).onNeighborBlockChange(block);
        }
    }

    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:reservoir");
        for (MbFace face : MbFace.values()) {
            this.mbIcons[face.ordinal()] = IIconRegister2.func_94245_a("enderio:" + face.iconName);
        }
        this.switchIcon = IIconRegister2.func_94245_a("enderio:reservoirSwitch");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int blockSide) {
        if (y < 0 || y >= 256) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return true;
        }
        TileReservoir tr = (TileReservoir)te;
        return !tr.isMultiblock();
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return this.field_149761_L;
        }
        TileReservoir tr = (TileReservoir)te;
        if (!tr.isMultiblock()) {
            return this.field_149761_L;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)blockSide);
        TileReservoir.Pos pos = tr.pos;
        if (tr.front == side || tr.front == side.getOpposite()) {
            boolean isRight = tr.isVertical() ? !pos.isRight(side) : pos.isRight(side);
            if (pos.isTop) {
                return isRight ? this.mbIcons[MbFace.TR.ordinal()] : this.mbIcons[MbFace.TL.ordinal()];
            }
            return isRight ? this.mbIcons[MbFace.BR.ordinal()] : this.mbIcons[MbFace.BL.ordinal()];
        }
        if (tr.up == side || tr.up == side.getOpposite()) {
            if (tr.isVertical()) {
                if (tr.right.offsetX != 0) {
                    return pos.isRight ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
                }
                return pos.isRight ? this.mbIcons[MbFace.T.ordinal()] : this.mbIcons[MbFace.B.ordinal()];
            }
            if (tr.up == side) {
                return pos.isRight ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
            }
            return pos.isRight ? this.mbIcons[MbFace.R.ordinal()] : this.mbIcons[MbFace.L.ordinal()];
        }
        if (tr.isVertical()) {
            return pos.isTop ? this.mbIcons[MbFace.T.ordinal()] : this.mbIcons[MbFace.B.ordinal()];
        }
        return pos.isTop(side) ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    private static enum MbFace {
        TL("reservoirMbTl"),
        TR("reservoirMbTr"),
        BL("reservoirMbBl"),
        BR("reservoirMbBr"),
        T("reservoirMbT"),
        B("reservoirMbB"),
        L("reservoirMbL"),
        R("reservoirMbR");

        String iconName;

        private MbFace(String iconName) {
            this.iconName = iconName;
        }
    }
}

