/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.gui.IGuiOverlay;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.gui.ToggleButtonEIO;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ClientChannelRegister;
import crazypants.enderio.machine.hypercube.ContainerHyperCube;
import crazypants.enderio.machine.hypercube.GuiChannelList;
import crazypants.enderio.machine.hypercube.PacketAddRemoveChannel;
import crazypants.enderio.machine.hypercube.PacketClientState;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiContainerBase;
import crazypants.gui.GuiScrollableList;
import crazypants.gui.GuiToolTip;
import crazypants.gui.ListSelectionListener;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.opengl.GL11;

public class GuiHyperCube
extends GuiContainerBase {
    protected static final int POWER_INPUT_BUTTON_ID = 1;
    protected static final int POWER_OUTPUT_BUTTON_ID = 2;
    protected static final int ADD_BUTTON_ID = 3;
    protected static final int PRIVATE_BUTTON_ID = 4;
    protected static final int SELECT_PRIVATE_BUTTON_ID = 5;
    protected static final int SELECT_PUBLIC_BUTTON_ID = 6;
    protected static final int DELETE_PRIVATE_BUTTON_ID = 7;
    protected static final int DELETE_PUBLIC_BUTTON_ID = 8;
    protected static final int POWER_MODE_BUTTON_ID = 9;
    protected static final int FLUID_MODE_BUTTON_ID = 10;
    private static final int ITEM_MODE_BUTTON_ID = 11;
    private static final int POWER_X = 227;
    private static final int POWER_Y = 46;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 66;
    protected static final int BOTTOM_POWER_Y = 112;
    private final TileHyperCube cube;
    private IconButtonEIO addButton;
    private ToggleButtonEIO privateButton;
    private GuiTextField newChannelTF;
    private GuiChannelList publicChannelList;
    private GuiChannelList privateChannelList;
    private ListSelectionListener<Channel> selectionListener;
    private IconButtonEIO selectPublicB;
    private IconButtonEIO deletePublicB;
    private IconButtonEIO selectPrivateB;
    private IconButtonEIO deletePrivateB;
    private IconButtonEIO powerB;
    private IconButtonEIO fluidB;
    private IconButtonEIO itemB;
    private RedstoneModeButton rsB;

    public GuiHyperCube(TileHyperCube te) {
        super(new ContainerHyperCube());
        this.cube = te;
        this.field_146999_f = 245;
        this.field_147000_g = 145;
        this.addToolTip(new GuiToolTip(new Rectangle(227, 46, 10, 66), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(GuiHyperCube.this.cube.getEnergyStored()) + " / " + PowerDisplayUtil.formatPower(GuiHyperCube.this.cube.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation());
            }
        });
        this.addButton = new IconButtonEIO(this, 3, 137, 12, IconEIO.PLUS);
        this.addButton.setToolTip(Lang.localize("gui.trans.addChannel"));
        this.addButton.field_146124_l = false;
        this.privateButton = new ToggleButtonEIO(this, 4, 118, 12, IconEIO.PUBLIC, IconEIO.PRIVATE);
        this.privateButton.setSelectedToolTip(Lang.localize("gui.trans.privateChannel"));
        this.privateButton.setUnselectedToolTip(Lang.localize("gui.trans.publicChannel"));
        this.deletePublicB = new IconButtonEIO(this, 8, 74, 117, IconEIO.MINUS);
        this.deletePublicB.setToolTip(Lang.localize("gui.trans.deleteChannel"));
        this.selectPublicB = new IconButtonEIO(this, 6, 95, 117, IconEIO.TICK);
        this.selectPublicB.setToolTip(Lang.localize("gui.trans.activateChannel"));
        this.deletePrivateB = new IconButtonEIO(this, 7, 183, 117, IconEIO.MINUS);
        this.deletePrivateB.setToolTip(Lang.localize("gui.trans.deleteChannel"));
        this.selectPrivateB = new IconButtonEIO(this, 5, 204, 117, IconEIO.TICK);
        this.selectPrivateB.setToolTip(Lang.localize("gui.trans.activateChannel"));
        int x = 163;
        int y = 12;
        this.itemB = new IconButtonEIO(this, 11, x, y, IconEIO.WRENCH_OVERLAY_ITEM);
        this.itemB.setIconMargin(3, 3);
        this.powerB = new IconButtonEIO(this, 9, x += 18, y, IconEIO.WRENCH_OVERLAY_POWER);
        this.powerB.setIconMargin(3, 3);
        this.fluidB = new IconButtonEIO(this, 10, x += 18, y, IconEIO.WRENCH_OVERLAY_FLUID);
        this.fluidB.setIconMargin(3, 3);
        this.rsB = new RedstoneModeButton(this, 99, x += 24, y, te, new BlockCoord(te));
        this.updateIoButtons();
        int w = 104;
        int h = 68;
        x = 7;
        y = 45;
        Channel activeChannel = this.cube.getChannel();
        this.publicChannelList = new GuiChannelList(this, w, h, x, y);
        this.publicChannelList.setChannels(ClientChannelRegister.instance.getPublicChannels());
        this.publicChannelList.setShowSelectionBox(true);
        this.publicChannelList.setScrollButtonIds(100, 101);
        this.publicChannelList.setActiveChannel(this.isPublic(activeChannel) ? activeChannel : null);
        x = x + 5 + w;
        this.privateChannelList = new GuiChannelList(this, w, h, x, y);
        this.privateChannelList.setChannels(ClientChannelRegister.instance.getPrivateChannels());
        this.privateChannelList.setShowSelectionBox(true);
        this.privateChannelList.setScrollButtonIds(102, 103);
        this.privateChannelList.setActiveChannel(this.isPrivate(activeChannel) ? activeChannel : null);
        this.selectionListener = new ListSelectionListener<Channel>(){

            @Override
            public void selectionChanged(GuiScrollableList<Channel> list, int selectedIndex) {
                Channel selected = list.getSelectedElement();
                if (selected != null) {
                    GuiChannelList clear = list == GuiHyperCube.this.publicChannelList ? GuiHyperCube.this.privateChannelList : GuiHyperCube.this.publicChannelList;
                    clear.setSelection(-1);
                }
            }
        };
        this.publicChannelList.addSelectionListener(this.selectionListener);
        this.privateChannelList.addSelectionListener(this.selectionListener);
    }

    private void updateIoButtons() {
        TileHyperCube.IoMode mode = this.cube.getModeForChannel(TileHyperCube.SubChannel.POWER);
        if (mode.isRecieveEnabled() || mode.isSendEnabled()) {
            this.powerB.setIcon(IconEIO.WRENCH_OVERLAY_POWER);
        } else {
            this.powerB.setIcon(IconEIO.WRENCH_OVERLAY_POWER_OFF);
        }
        this.powerB.setToolTip(Lang.localize("gui.trans.powerMode"), mode.getLocalisedName());
        mode = this.cube.getModeForChannel(TileHyperCube.SubChannel.FLUID);
        if (mode.isRecieveEnabled() || mode.isSendEnabled()) {
            this.fluidB.setIcon(IconEIO.WRENCH_OVERLAY_FLUID);
        } else {
            this.fluidB.setIcon(IconEIO.WRENCH_OVERLAY_FLUID_OFF);
        }
        this.fluidB.setToolTip(Lang.localize("gui.trans.fluidMode"), mode.getLocalisedName());
        mode = this.cube.getModeForChannel(TileHyperCube.SubChannel.ITEM);
        if (mode.isRecieveEnabled() || mode.isSendEnabled()) {
            this.itemB.setIcon(IconEIO.WRENCH_OVERLAY_ITEM);
        } else {
            this.itemB.setIcon(IconEIO.WRENCH_OVERLAY_ITEM_OFF);
        }
        this.itemB.setToolTip(Lang.localize("gui.trans.itemMode"), mode.getLocalisedName());
    }

    private boolean isPublic(Channel chan) {
        if (chan == null) {
            return false;
        }
        return chan.isPublic();
    }

    private boolean isPrivate(Channel chan) {
        if (chan == null) {
            return false;
        }
        return !chan.isPublic();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int x = this.field_147003_i + 203;
        int y = this.field_147009_r + 12;
        y = this.field_147009_r + 12;
        x = this.field_147003_i + 8;
        this.newChannelTF = new GuiTextField(this.getFontRenderer(), x, y, 103, 16);
        this.newChannelTF.func_146205_d(false);
        this.newChannelTF.func_146203_f(32);
        this.newChannelTF.func_146195_b(true);
        this.privateButton.onGuiInit();
        this.addButton.onGuiInit();
        this.selectPrivateB.onGuiInit();
        this.selectPublicB.onGuiInit();
        this.deletePrivateB.onGuiInit();
        this.deletePublicB.onGuiInit();
        this.powerB.onGuiInit();
        this.fluidB.onGuiInit();
        this.itemB.onGuiInit();
        this.publicChannelList.onGuiInit(this);
        this.privateChannelList.onGuiInit(this);
        this.rsB.onGuiInit();
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k == 10) {
            TileHyperCube.IoMode curMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.FLUID);
            TileHyperCube.IoMode nextMode = curMode.next();
            this.cube.setModeForChannel(TileHyperCube.SubChannel.FLUID, nextMode);
            this.updateIoButtons();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.cube));
        } else if (par1GuiButton.field_146127_k == 9) {
            TileHyperCube.IoMode curMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.POWER);
            TileHyperCube.IoMode nextMode = curMode.next();
            this.cube.setModeForChannel(TileHyperCube.SubChannel.POWER, nextMode);
            this.updateIoButtons();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.cube));
        } else if (par1GuiButton.field_146127_k == 11) {
            TileHyperCube.IoMode curMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.ITEM);
            TileHyperCube.IoMode nextMode = curMode.next();
            this.cube.setModeForChannel(TileHyperCube.SubChannel.ITEM, nextMode);
            this.updateIoButtons();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.cube));
        } else if (par1GuiButton.field_146127_k == 3) {
            Channel c = this.privateButton.isSelected() ? new Channel(this.newChannelTF.func_146179_b(), Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName()) : new Channel(this.newChannelTF.func_146179_b(), null);
            ClientChannelRegister.instance.addChannel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(true, c));
            this.setActiveChannel(c);
            if (this.privateButton.isSelected()) {
                this.privateChannelList.setSelection(c);
            } else {
                this.publicChannelList.setSelection(c);
            }
        } else if (par1GuiButton.field_146127_k == 6 || par1GuiButton.field_146127_k == 5) {
            Channel c;
            Channel channel = c = par1GuiButton.field_146127_k == 6 ? (Channel)this.publicChannelList.getSelectedElement() : (Channel)this.privateChannelList.getSelectedElement();
            if (c != null) {
                this.setActiveChannel(c);
            }
        } else if (par1GuiButton.field_146127_k == 7 || par1GuiButton.field_146127_k == 8) {
            Channel c;
            Channel channel = c = par1GuiButton.field_146127_k == 8 ? (Channel)this.publicChannelList.getSelectedElement() : (Channel)this.privateChannelList.getSelectedElement();
            if (c != null) {
                if (c.equals(this.cube.getChannel())) {
                    this.setActiveChannel(null);
                }
                ClientChannelRegister.instance.channelRemoved(c);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(false, c));
            }
        }
    }

    private void setActiveChannel(Channel c) {
        this.cube.setChannel(c);
        this.publicChannelList.setActiveChannel(this.isPublic(c) ? c : null);
        this.privateChannelList.setActiveChannel(this.isPrivate(c) ? c : null);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.cube));
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            for (IGuiOverlay overlay : this.overlays) {
                if (!overlay.isVisible()) continue;
                overlay.setVisible(false);
                return;
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.newChannelTF.func_146201_a(par1, par2);
        this.addButton.field_146124_l = this.newChannelTF.func_146179_b().trim().length() > 0;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.newChannelTF.func_146192_a(par1, par2, par3);
    }

    public void func_73876_c() {
        this.newChannelTF.func_146178_a();
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        boolean chanSel;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/hyperCube.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.cube.getEnergyStoredScaled(66);
        this.func_73729_b(sx + 227, sy + 112 - i1, 245, 0, 10, i1);
        this.selectPublicB.field_146124_l = chanSel = this.publicChannelList.getSelectedElement() != null;
        this.deletePublicB.field_146124_l = chanSel;
        this.selectPrivateB.field_146124_l = chanSel = this.privateChannelList.getSelectedElement() != null;
        this.deletePrivateB.field_146124_l = chanSel;
        this.newChannelTF.func_146194_f();
        this.publicChannelList.drawScreen(mouseX, mouseY, partialTick);
        this.privateChannelList.drawScreen(mouseX, mouseY, partialTick);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        int x = this.field_147003_i + 12;
        int y = this.field_147009_r + 35;
        int rgb = ColorUtil.getRGB(Color.white);
        this.func_73731_b(this.getFontRenderer(), Lang.localize("gui.trans.publicHeading"), x, y, rgb);
        this.func_73731_b(this.getFontRenderer(), Lang.localize("gui.trans.privateHeading"), x += 109, y, rgb);
        TileHyperCube.IoMode fluidMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.FLUID);
        TileHyperCube.IoMode powerMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.POWER);
        TileHyperCube.IoMode itemMode = this.cube.getModeForChannel(TileHyperCube.SubChannel.ITEM);
        x = 163;
        if (itemMode.isRecieveEnabled()) {
            IconEIO.INPUT.renderIcon(this.field_147003_i + x + 15, this.field_147009_r + 4 + 7, -15.0, -7.0, 0.0, true);
        }
        x += 18;
        if (powerMode.isRecieveEnabled()) {
            IconEIO.INPUT.renderIcon(this.field_147003_i + x + 15, this.field_147009_r + 4 + 7, -15.0, -7.0, 0.0, true);
        }
        x += 18;
        if (fluidMode.isRecieveEnabled()) {
            IconEIO.INPUT.renderIcon(this.field_147003_i + x + 15, this.field_147009_r + 4 + 7, -15.0, -7.0, 0.0, true);
        }
        x = 163;
        if (itemMode.isSendEnabled()) {
            IconEIO.OUTPUT.renderIcon(this.field_147003_i + x, this.field_147009_r + 29, 15.0, 7.0, 0.0, true);
        }
        x += 18;
        if (powerMode.isSendEnabled()) {
            IconEIO.OUTPUT.renderIcon(this.field_147003_i + x, this.field_147009_r + 29, 15.0, 7.0, 0.0, true);
        }
        x += 18;
        if (fluidMode.isSendEnabled()) {
            IconEIO.OUTPUT.renderIcon(this.field_147003_i + x, this.field_147009_r + 29, 15.0, 7.0, 0.0, true);
        }
    }

    @Override
    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        super.drawHoveringText(par1List, par2, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public int getXSize() {
        return this.field_146999_f;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }
}

