/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.gui.GuiToolTip;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiZombieGenerator
extends GuiPoweredMachineBase<TileZombieGenerator> {
    public GuiZombieGenerator(InventoryPlayer inventory, TileZombieGenerator tileEntity) {
        super(tileEntity, new ContainerZombieGenerator(inventory, tileEntity));
        this.addToolTip(new GuiToolTip(new Rectangle(80, 21, 15, 47), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                String heading = Lang.localize("zombieGenerator.fuelTank");
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileZombieGenerator)((GuiZombieGenerator)GuiZombieGenerator.this).getTileEntity()).fuelTank));
            }
        });
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 78;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/zombieGenerator.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        TileZombieGenerator gen = (TileZombieGenerator)this.getTileEntity();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = gen.outputPerTick;
        }
        String txt = Lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.func_78256_a(txt);
        fr.func_78261_a(txt, this.field_147003_i + this.field_146999_f / 2 - sw / 2, this.field_147009_r + fr.field_78288_b / 2 + 3, ColorUtil.getRGB(Color.WHITE));
        int x = this.field_147003_i + 80;
        int y = this.field_147009_r + 21;
        if (gen.fuelTank.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank(gen.fuelTank.getFluid(), gen.fuelTank.getCapacity(), gen.fuelTank.getFluidAmount(), x, y, this.field_73735_i, 16.0, 47.0);
            if (gen.isActive()) {
                txt = gen.tickPerBucketOfFuel / 1000 + " t/Mb";
                sw = fr.func_78256_a(txt);
                fr.func_78261_a(txt, x - sw / 2 + 7, y + fr.field_78288_b / 2 + 46, ColorUtil.getRGB(Color.WHITE));
            }
        }
        RenderUtil.bindTexture("enderio:textures/gui/zombieGenerator.png");
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected int getPowerX() {
        return 15;
    }

    @Override
    protected int getPowerY() {
        return 20;
    }

    @Override
    protected int getPowerHeight() {
        return 48;
    }
}

