/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.combustion.BlockCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.FacingVertexTransform;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.TranslatedCubeRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.CustomCubeRenderer;
import crazypants.render.CustomRenderBlocks;
import crazypants.render.IRenderFace;
import crazypants.render.RenderUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vertex;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class CombustionGeneratorRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private CustomCubeRenderer ccr = new CustomCubeRenderer();
    private OverlayRenderer overlayRenderer = new OverlayRenderer();
    private FacingVertexTransform vt = new FacingVertexTransform();
    private TileCombustionGenerator gen;

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        short facing = (short)ForgeDirection.SOUTH.ordinal();
        boolean active = false;
        if (world != null) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileCombustionGenerator) {
                this.gen = (TileCombustionGenerator)te;
                facing = this.gen.facing;
                active = this.gen.isActive();
            } else {
                this.gen = null;
            }
        }
        boolean scaleX = facing != 4 && facing != 5;
        BoundingBox bb = BoundingBox.UNIT_CUBE;
        bb = bb.scale(1.0, 0.34, 1.0);
        this.vt.setFacing(facing);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, null, world != null);
        scaleX = facing != 4 && facing != 5;
        float scx = scaleX ? 0.7f : 1.0f;
        float scz = scaleX ? 1.0f : 0.7f;
        bb = BoundingBox.UNIT_CUBE;
        bb = bb.scale((double)scx, 0.21, (double)scz);
        bb = bb.translate(0.0f, 0.26f, 0.0f);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, null, world != null);
        bb = BoundingBox.UNIT_CUBE;
        bb = bb.scale((double)scx, 0.21, (double)scz);
        bb = bb.translate(0.0f, -0.26f, 0.0f);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, null, world != null);
        bb = BoundingBox.UNIT_CUBE.scale(0.35, 1.0, 0.35);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, null, world != null);
        float size = 0.64f;
        bb = BoundingBox.UNIT_CUBE.scale(0.98, 1.0, 0.98);
        scx = scaleX ? size : 1.0f;
        scz = scaleX ? 1.0f : size;
        bb = bb.scale(scx, 1.0f, scz);
        float tx = scaleX ? 0.5f : 0.0f;
        float tz = scaleX ? 0.0f : 0.5f;
        bb = bb.translate(tx, 0.0f, tz);
        IIcon tex = Config.combustionGeneratorUseOpaqueModel ? EnderIO.blockCombustionGenerator.func_149691_a(4, 0) : EnderIO.blockFusedQuartz.getDefaultFrameIcon(0);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, tex, world != null);
        bb = bb.translate(-tx * 2.0f, 0.0f, -tz * 2.0f);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.vt, tex, world != null);
        if (this.gen != null) {
            this.ccr.renderBlock(world, block, x, y, z, this.overlayRenderer);
        }
        this.gen = null;
        return true;
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float var8) {
        TileCombustionGenerator gen = (TileCombustionGenerator)tileentity;
        if (gen.getCoolantTank().getFluidAmount() <= 0 && gen.getFuelTank().getFluidAmount() <= 0) {
            return;
        }
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        float val = RenderUtil.claculateTotalBrightnessForLocation(tileentity.func_145831_w(), tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e);
        GL11.glColor3f((float)val, (float)val, (float)val);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtil.bindBlockTexture();
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78373_b(x, y, z);
        tes.func_78382_b();
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.96, 0.96, 0.96);
        this.renderTank(gen, bb, gen.getCoolantTank(), true);
        this.renderTank(gen, bb, gen.getFuelTank(), false);
        tes.func_78381_a();
        tes.func_78373_b(0.0, 0.0, 0.0);
        GL11.glPopAttrib();
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    private void renderTank(TileCombustionGenerator gen, BoundingBox bb, FluidTank tank, boolean isLeft) {
        IIcon icon;
        boolean scaleX = gen.getFacing() != 4 && gen.getFacing() != 5;
        float size = 0.34f;
        if (gen.getFacing() == 5 || gen.getFacing() == 2) {
            boolean bl = isLeft = !isLeft;
        }
        if (tank.getFluidAmount() > 0 && (icon = tank.getFluid().getFluid().getStillIcon()) != null) {
            float fullness = (float)(tank.getFluidAmount() - 1000) / (float)(tank.getCapacity() - 1000);
            float scx = scaleX ? size : 1.0f;
            float scz = scaleX ? 1.0f : size;
            bb = bb.scale((double)scx, 0.97 * (double)fullness, (double)scz);
            float tx = scaleX ? 0.3125f : 0.0f;
            float tz = scaleX ? 0.0f : 0.3125f;
            float ty = -(0.98f - (bb.maxY - bb.minY)) / 2.0f;
            if (!isLeft) {
                tx = -tx;
                tz = -tz;
            }
            bb = bb.translate(tx, ty, tz);
            CubeRenderer.render(bb, icon);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)2896);
        tes.func_78382_b();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        tes.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public int getRenderId() {
        return BlockCombustionGenerator.renderId;
    }

    private class OverlayRenderer
    implements IRenderFace {
        private OverlayRenderer() {
        }

        @Override
        public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXyz) {
            if (CombustionGeneratorRenderer.this.gen != null && par1Block instanceof AbstractMachineBlock) {
                Vector3d offset = ForgeDirectionOffsets.offsetScaled(face, 0.01);
                Tessellator.field_78398_a.func_78372_c((float)offset.x, (float)offset.y, (float)offset.z);
                IoMode mode = CombustionGeneratorRenderer.this.gen.getIoMode(face);
                IIcon tex = ((AbstractMachineBlock)par1Block).getOverlayIconForMode(mode);
                if (tex != null) {
                    CombustionGeneratorRenderer.this.ccr.getCustomRenderBlocks().doDefaultRenderFace(face, par1Block, x, y, z, tex);
                }
                Tessellator.field_78398_a.func_78372_c(-((float)offset.x), -((float)offset.y), -((float)offset.z));
            }
        }
    }
}

