/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.render.BoundingBox;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class IoDisplay
implements IInfoRenderer {
    @Override
    public void render(TileCapBank cb, ForgeDirection dir, double x, double y, double z, float partialTick) {
        boolean selfIlum = true;
        int brightness = 0;
        if (!selfIlum) {
            brightness = cb.func_145831_w().func_72802_i(cb.field_145851_c + dir.offsetX, cb.field_145848_d + dir.offsetY, cb.field_145849_e + dir.offsetZ, 0);
            int l1 = brightness % 65536;
            int l2 = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        } else {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        boolean drawBackground = true;
        if (drawBackground) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            if (!selfIlum) {
                tes.func_78380_c(brightness);
            }
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            double scale = 0.85;
            BoundingBox bb = BoundingBox.UNIT_CUBE;
            double xScale = dir.offsetX == 0 ? scale : 1.0;
            double yScale = scale;
            double zScale = dir.offsetZ == 0 ? scale : 1.0;
            bb = bb.scale(xScale, yScale, zScale);
            IIcon icon = EnderIO.blockCapBank.getInfoPanelIcon();
            List<Vertex> verts = bb.getCornersWithUvForFace(dir, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
            RenderUtil.addVerticesToTesselator(verts);
            tes.func_78381_a();
        }
        CapBankClientNetwork nw = null;
        if (cb.getNetwork() == null) {
            return;
        }
        nw = (CapBankClientNetwork)cb.getNetwork();
        nw.requestPowerUpdate(cb, 20);
        int change = Math.round(nw.getAverageChangePerTick());
        Vector3f col = new Vector3f(0.0f, 0.0f, 0.0f);
        if (change > 0) {
            col = new Vector3f(0.0, 0.025, 0.0);
        } else if (change < 0) {
            col = new Vector3f(0.05, 0.0, 0.0);
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String changeText = this.getChangeText(change, fr);
        String HeadingText = change > 0 ? "In" : (change < 0 ? "Out" : "I/O");
        float size = 0.15f;
        float scale = size / (float)fr.field_78288_b;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)(0.5f + size / 2.0f), (float)0.5f);
        GL11.glTranslatef((float)((float)((double)dir.offsetX * 1.01) / 2.0f), (float)0.0f, (float)((float)((double)dir.offsetZ * 1.01) / 2.0f));
        GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (dir == ForgeDirection.NORTH) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.EAST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.WEST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-size), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(HeadingText, -fr.func_78256_a(HeadingText) / 2, 0, ColorUtil.getRGB(col));
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(size / 2.0f), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(changeText, -fr.func_78256_a(changeText) / 2, 0, ColorUtil.getRGB(col));
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected String getChangeText(int change, FontRenderer fr) {
        String txt = PowerDisplayUtil.INT_NF.format(change = Math.abs(change));
        int width = fr.func_78256_a(txt);
        if (width > 38 && change > 1000) {
            txt = PowerDisplayUtil.INT_NF.format(change /= 1000) + "K";
        }
        return txt;
    }
}

