/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.InventoryImpl;
import crazypants.enderio.machine.capbank.network.NetworkState;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateRequest;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IPowerStorage;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CapBankClientNetwork
implements ICapBankNetwork {
    private final int id;
    private final List<TileCapBank> members = new ArrayList<TileCapBank>();
    private int maxEnergySent;
    private int maxEnergyRecieved;
    private int stateUpdateCount;
    private int maxIO;
    private long maxEnergyStored;
    private long energyStored;
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private final InventoryImpl inventory = new InventoryImpl();
    private float aveChange;
    private long lastPowerRequestTick = -1L;

    public CapBankClientNetwork(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void requestPowerUpdate(TileCapBank capBank, int interval) {
        long curTick = EnderIO.proxy.getTickCount();
        if (this.lastPowerRequestTick == -1L || curTick - this.lastPowerRequestTick >= (long)interval) {
            if (this.stateUpdateCount == 0) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(capBank));
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkEnergyRequest(capBank));
            this.lastPowerRequestTick = curTick;
        }
    }

    public void setState(World world, NetworkState state) {
        this.maxEnergyRecieved = state.getMaxInput();
        this.maxEnergySent = state.getMaxOutput();
        this.maxIO = state.getMaxIO();
        this.maxEnergyStored = state.getMaxEnergyStored();
        this.energyStored = state.getEnergyStored();
        this.inputControlMode = state.getInputMode();
        this.outputControlMode = state.getOutputMode();
        BlockCoord bc = state.getInventoryImplLocation();
        if (bc == null) {
            this.inventory.setCapBank(null);
        } else {
            TileEntity te = world.func_147438_o(bc.x, bc.y, bc.z);
            if (te instanceof TileCapBank) {
                this.inventory.setCapBank((TileCapBank)te);
            }
        }
        this.aveChange = state.getAverageChange();
        ++this.stateUpdateCount;
    }

    public int getStateUpdateCount() {
        return this.stateUpdateCount;
    }

    public void setStateUpdateCount(int stateUpdateCount) {
        this.stateUpdateCount = stateUpdateCount;
    }

    @Override
    public void addMember(TileCapBank capBank) {
        this.members.add(capBank);
    }

    @Override
    public List<TileCapBank> getMembers() {
        return this.members;
    }

    @Override
    public void destroyNetwork() {
        for (TileCapBank cb : this.members) {
            cb.setNetworkId(-1);
            cb.setNetwork(null);
        }
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.maxEnergyStored;
    }

    public void setMaxEnergyStoredL(long maxEnergyStored) {
        this.maxEnergyStored = maxEnergyStored;
    }

    public void setEnergyStored(long energyStored) {
        this.energyStored = energyStored;
    }

    @Override
    public long getEnergyStoredL() {
        return this.energyStored;
    }

    @Override
    public int getMaxOutput() {
        return this.maxEnergySent;
    }

    @Override
    public void setMaxOutput(int max) {
        this.maxEnergySent = MathHelper.func_76125_a((int)max, (int)0, (int)this.maxIO);
    }

    @Override
    public int getMaxInput() {
        return this.maxEnergyRecieved;
    }

    @Override
    public void setMaxInput(int max) {
        this.maxEnergyRecieved = MathHelper.func_76125_a((int)max, (int)0, (int)this.maxIO);
    }

    public double getEnergyStoredRatio() {
        if (this.getMaxEnergyStoredL() <= 0L) {
            return 0.0;
        }
        return (double)this.getEnergyStoredL() / (double)this.getMaxEnergyStoredL();
    }

    @Override
    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    @Override
    public void setInputControlMode(RedstoneControlMode inputControlMode) {
        this.inputControlMode = inputControlMode;
    }

    @Override
    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    @Override
    public void setOutputControlMode(RedstoneControlMode outputControlMode) {
        this.outputControlMode = outputControlMode;
    }

    @Override
    public InventoryImpl getInventory() {
        return this.inventory;
    }

    @Override
    public float getAverageChangePerTick() {
        return this.aveChange;
    }

    public void setAverageChangePerTick(float aveChange) {
        this.aveChange = aveChange;
    }

    @Override
    public NetworkState getState() {
        return new NetworkState(this);
    }

    @Override
    public void onUpdateEntity(TileCapBank tileCapBank) {
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public int recieveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public void removeReceptors(Collection<EnergyReceptor> receptors) {
    }

    @Override
    public void addReceptors(Collection<EnergyReceptor> receptors) {
    }

    @Override
    public void updateRedstoneSignal(TileCapBank tileCapBank, boolean recievingSignal) {
    }

    @Override
    public boolean isOutputEnabled() {
        return true;
    }

    @Override
    public boolean isInputEnabled() {
        return true;
    }

    @Override
    public IPowerStorage getController() {
        return this;
    }

    @Override
    public boolean isOutputEnabled(ForgeDirection direction) {
        return this.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(ForgeDirection direction) {
        return this.isInputEnabled();
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public boolean isNetworkControlledIo(ForgeDirection direction) {
        return true;
    }
}

