/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.buffer.BlockItemBuffer;
import crazypants.enderio.machine.buffer.ContainerBuffer;
import crazypants.enderio.machine.buffer.GuiBuffer;
import crazypants.enderio.machine.buffer.PacketBufferIO;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.IFacade;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBuffer
extends AbstractMachineBlock<TileBuffer>
implements IFacade {
    private static final String[] textureNames = new String[]{"blockBufferItem", "blockBufferPower", "blockBufferOmni", "blockBufferCreative"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;

    public static BlockBuffer create() {
        PacketHandler.INSTANCE.registerMessage(PacketBufferIO.class, PacketBufferIO.class, PacketHandler.nextID(), Side.SERVER);
        BlockBuffer res = new BlockBuffer();
        res.init();
        return res;
    }

    private BlockBuffer() {
        super(ModObject.blockBuffer, TileBuffer.class);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemBuffer.class, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBuffer) {
            return new ContainerBuffer(player.field_71071_by, (TileBuffer)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBuffer) {
            return new GuiBuffer(player.field_71071_by, (TileBuffer)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        super.func_149651_a(iIconRegister);
        this.textures = new IIcon[textureNames.length];
        for (int i = 0; i < textureNames.length; ++i) {
            this.textures[i] = iIconRegister.func_94245_a("enderio:" + textureNames[i]);
        }
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return this.getSideIconKey(active);
    }

    @Override
    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return blockSide > 1 ? this.textures[blockMeta] : super.func_149691_a(blockSide, blockMeta);
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBuffer) {
            TileBuffer tef = (TileBuffer)te;
            if (tef.getSourceBlock() != null) {
                return tef.getSourceBlock().func_149691_a(blockSide, tef.getSourceBlockMetadata());
            }
            if (blockSide > 1) {
                return this.textures[world.func_72805_g(x, y, z)];
            }
        }
        return super.func_149673_e(world, x, y, z, blockSide);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.func_147438_o(x, y, z)) instanceof TileBuffer) {
            TileBuffer ta = (TileBuffer)te;
            if (stack.field_77990_d != null) {
                ta.readCommon(stack.field_77990_d);
            }
            world.func_147471_g(x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return Lists.newArrayList();
    }

    @Override
    protected boolean shouldDropDefaultItem(World world, EntityPlayer player, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileBuffer) {
            TileBuffer cb = (TileBuffer)te;
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_149642_a(world, x, y, z, this.createDrop(cb));
            }
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    private ItemStack createDrop(TileBuffer te) {
        ItemStack stack = new ItemStack((Block)this, 1, BlockItemBuffer.Type.get(te).ordinal());
        stack.field_77990_d = new NBTTagCompound();
        te.writeCommon(stack.field_77990_d);
        return stack;
    }

    public ItemStack createItemStackForSourceBlock(ItemStack machine, Block block, int sourceMeta) {
        PainterUtil.setSourceBlock(machine, block, sourceMeta);
        return machine;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBuffer) {
            return ((TileBuffer)te).getSourceBlockMetadata();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBuffer) {
            return ((TileBuffer)te).getSourceBlock();
        }
        return this;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{BlockBuffer.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockBuffer.this.createItemStackForSourceBlock(MachineRecipeInput.getInputForSlot(0, inputs).func_77946_l(), Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }
    }
}

