/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.PacketCurrentTaskProgress;
import crazypants.enderio.machine.PacketIoMode;
import crazypants.enderio.machine.PacketItemBuffer;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.ToolUtil;
import crazypants.enderio.waila.IWailaInfoProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractMachineBlock<T extends AbstractMachineEntity>
extends BlockContainer
implements IGuiHandler,
IResourceTooltipProvider,
IWailaInfoProvider {
    public static int renderId;
    public IIcon overlayIconPull;
    public IIcon overlayIconPush;
    public IIcon overlayIconPushPull;
    public IIcon overlayIconDisabled;
    public IIcon overlayIconNone;
    public IIcon selectedFaceIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[][] iconBuffer;
    protected final Random random;
    protected final ModObject modObject;
    protected final Class<T> teClass;

    protected AbstractMachineBlock(ModObject mo, Class<T> teClass, Material mat) {
        super(mat);
        this.modObject = mo;
        this.teClass = teClass;
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149663_c(mo.unlocalisedName);
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.random = new Random();
    }

    protected AbstractMachineBlock(ModObject mo, Class<T> teClass) {
        this(mo, teClass, new Material(MapColor.field_151668_h));
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity(this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        try {
            return (TileEntity)this.teClass.newInstance();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Could not create tile entity from class " + this.teClass, true);
            return null;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te;
        if (ToolUtil.breakBlockWithTool((Block)this, world, x, y, z, entityPlayer)) {
            return true;
        }
        ITool tool = ToolUtil.getEquippedTool(entityPlayer);
        if (tool != null && !entityPlayer.func_70093_af() && (te = world.func_147438_o(x, y, z)) instanceof AbstractMachineEntity) {
            ((AbstractMachineEntity)te).toggleIoModeForFace(ForgeDirection.getOrientation((int)side));
            world.func_147471_g(x, y, z);
            return true;
        }
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, this.getGuiId(), world, x, y, z);
        }
        return true;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.iconBuffer = new IIcon[1][12];
        String side = this.getSideIconKey(false);
        this.iconBuffer[0][0] = iIconRegister.func_94245_a(side);
        this.iconBuffer[0][1] = iIconRegister.func_94245_a(this.getTopIconKey(false));
        this.iconBuffer[0][2] = iIconRegister.func_94245_a(this.getBackIconKey(false));
        this.iconBuffer[0][3] = iIconRegister.func_94245_a(this.getMachineFrontIconKey(false));
        this.iconBuffer[0][4] = iIconRegister.func_94245_a(side);
        this.iconBuffer[0][5] = iIconRegister.func_94245_a(side);
        side = this.getSideIconKey(true);
        this.iconBuffer[0][6] = iIconRegister.func_94245_a(side);
        this.iconBuffer[0][7] = iIconRegister.func_94245_a(this.getTopIconKey(true));
        this.iconBuffer[0][8] = iIconRegister.func_94245_a(this.getBackIconKey(true));
        this.iconBuffer[0][9] = iIconRegister.func_94245_a(this.getMachineFrontIconKey(true));
        this.iconBuffer[0][10] = iIconRegister.func_94245_a(side);
        this.iconBuffer[0][11] = iIconRegister.func_94245_a(side);
        this.registerOverlayIcons(iIconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerOverlayIcons(IIconRegister iIconRegister) {
        this.overlayIconPull = iIconRegister.func_94245_a("enderio:machineOverlayPull");
        this.overlayIconPush = iIconRegister.func_94245_a("enderio:machineOverlayPush");
        this.overlayIconPushPull = iIconRegister.func_94245_a("enderio:machineOverlayPushPull");
        this.overlayIconDisabled = iIconRegister.func_94245_a("enderio:machineOverlayDisabled");
        this.overlayIconNone = iIconRegister.func_94245_a("enderio:machineOverlayNone");
        this.selectedFaceIcon = iIconRegister.func_94245_a("enderio:machineOverlaySelectedFace");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIconForMode(IoMode mode) {
        if (mode == null) {
            return null;
        }
        switch (mode) {
            case DISABLED: {
                return this.overlayIconDisabled;
            }
            case PULL: {
                return this.overlayIconPull;
            }
            case PUSH: {
                return this.overlayIconPush;
            }
            case PUSH_PULL: {
                return this.overlayIconPushPull;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        short facing = 0;
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            facing = me.facing;
        }
        if (this.isActive(world, x, y, z)) {
            return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int blockSide, int blockMeta) {
        return this.iconBuffer[0][blockSide];
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    protected boolean shouldDropDefaultItem(World world, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (te = world.func_147438_o(x, y, z)) instanceof AbstractMachineEntity && this.shouldDropDefaultItem(world, player, x, y, z)) {
            AbstractMachineEntity machineEntity = (AbstractMachineEntity)te;
            int meta = this.func_149692_a(world.func_72805_g(x, y, z));
            ItemStack itemStack = new ItemStack((Block)this, 1, meta);
            machineEntity.writeToItemStack(itemStack);
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        return super.removedByPlayer(world, player, x, y, z, doHarvest);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        AbstractMachineEntity te = (AbstractMachineEntity)world.func_147438_o(x, y, z);
        te.setFacing(this.getFacingForHeading(heading));
        te.readFromItemStack(stack);
        if (world.field_72995_K) {
            return;
        }
        world.func_147471_g(x, y, z);
    }

    protected short getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147471_g(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        TileEntity ent = world.func_147438_o(x, y, z);
        if (ent instanceof AbstractMachineEntity) {
            AbstractMachineEntity te = (AbstractMachineEntity)ent;
            te.onNeighborBlockChange(blockId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            float startX = (float)x + 1.0f;
            float startY = (float)y + 1.0f;
            float startZ = (float)z + 1.0f;
            for (int i = 0; i < 4; ++i) {
                float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                float zOffset = -0.2f - rand.nextFloat() * 0.6f;
                world.func_72869_a("smoke", (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract int getGuiId();

    protected abstract String getMachineFrontIconKey(boolean var1);

    protected String getSideIconKey(boolean active) {
        return "enderio:machineSide";
    }

    protected String getBackIconKey(boolean active) {
        return "enderio:machineBack";
    }

    protected String getTopIconKey(boolean active) {
        return "enderio:machineTop";
    }

    protected boolean isActive(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof AbstractMachineEntity) {
            return ((AbstractMachineEntity)te).isActive();
        }
        return false;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 7;
    }

    protected void setObeliskBounds() {
        this.func_149676_a(0.11f, 0.0f, 0.11f, 0.91f, 0.48f, 0.91f);
    }

    static {
        PacketHandler.INSTANCE.registerMessage(PacketIoMode.class, PacketIoMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemBuffer.class, PacketItemBuffer.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerStorage.class, PacketPowerStorage.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketCurrentTaskProgress.class, PacketCurrentTaskProgress.class, PacketHandler.nextID(), Side.CLIENT);
    }
}

