/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.EnergyUpgrade;
import crazypants.enderio.item.darksteel.GliderUpgrade;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.JumpUpgrade;
import crazypants.enderio.item.darksteel.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.PacketDarkSteelPowerPacket;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SolarUpgrade;
import crazypants.enderio.item.darksteel.SpeedUpgrade;
import crazypants.enderio.item.darksteel.SwimUpgrade;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.Util;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector4d;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;

public class DarkSteelController {
    public static final DarkSteelController instance = new DarkSteelController();
    private AttributeModifier[] walkModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[2], 1)};
    private AttributeModifier[] sprintModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[2], 1)};
    private AttributeModifier swordDamageModifierPowered = new AttributeModifier(new UUID(63242325L, 320981923L), "Weapon modifier", 2.0, 0);
    private boolean wasJumping;
    private int jumpCount;
    private int ticksSinceLastJump;
    private Map<String, Boolean> glideActiveMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> speedActiveMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> stepAssistActiveMap = new HashMap<String, Boolean>();
    private boolean nightVisionActive = false;
    private boolean removeNightvision = false;

    private DarkSteelController() {
        PacketHandler.INSTANCE.registerMessage(PacketDarkSteelPowerPacket.class, PacketDarkSteelPowerPacket.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.SERVER);
    }

    public void setGlideActive(EntityPlayer player, boolean isGlideActive) {
        if (player.func_146103_bH().getName() != null) {
            this.glideActiveMap.put(player.func_146103_bH().getName(), isGlideActive);
        }
    }

    public boolean isGlideActive(EntityPlayer player) {
        Boolean isActive = this.glideActiveMap.get(player.func_146103_bH().getName());
        if (isActive == null) {
            return false;
        }
        return isActive;
    }

    public void setSpeedActive(EntityPlayer player, boolean isSpeedActive) {
        if (player.func_146103_bH().getName() != null) {
            this.speedActiveMap.put(player.func_146103_bH().getName(), isSpeedActive);
        }
    }

    public boolean isSpeedActive(EntityPlayer player) {
        Boolean isActive = this.speedActiveMap.get(player.func_146103_bH().getName());
        if (isActive == null) {
            return true;
        }
        return isActive;
    }

    public void setStepAssistActive(EntityPlayer player, boolean isActive) {
        if (player.func_146103_bH().getName() != null) {
            this.stepAssistActiveMap.put(player.func_146103_bH().getName(), isActive);
        }
    }

    public boolean isStepAssistActive(EntityPlayer player) {
        Boolean isActive = this.stepAssistActiveMap.get(player.func_146103_bH().getName());
        if (isActive == null) {
            return true;
        }
        return isActive;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START) {
            this.updateStepHeightAndFallDistance(player);
            this.updateSpeed(player);
            this.updateSword(player);
            this.updateGlide(player);
            this.updateSwim(player);
            this.updateSolar(player);
        }
    }

    private void updateSolar(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack helm = player.func_71124_b(4);
        SolarUpgrade upgrade = SolarUpgrade.loadFromItem(helm);
        if (upgrade == null) {
            return;
        }
        int RFperSecond = Math.round((float)upgrade.getRFPerSec() * TileEntitySolarPanel.calculateLightRatio(player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + 1.0)), MathHelper.func_76128_c((double)player.field_70161_v)));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.field_70170_p.func_82737_E() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().func_74762_e("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = player.field_71071_by.field_70460_b[nextIndex];
                if (EnergyUpgrade.loadFromItem(stack) != null) {
                    toAdd -= ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().func_74768_a("dsarmor:solar", nextIndex);
        }
    }

    private void updateSwim(EntityPlayer player) {
        ItemStack boots = player.func_71124_b(1);
        SwimUpgrade upgrade = SwimUpgrade.loadFromItem(boots);
        if (upgrade == null) {
            return;
        }
        if (player.func_70090_H()) {
            player.field_70159_w *= 1.1;
            player.field_70179_y *= 1.1;
        }
    }

    private void updateGlide(EntityPlayer player) {
        if (!this.isGlideActive(player) || !this.isGliderUpgradeEquipped(player)) {
            return;
        }
        if (!player.field_70122_E && player.field_70181_x < 0.0 && !player.func_70093_af() && !player.func_70090_H()) {
            double horizontalSpeed = Config.darkSteelGliderHorizontalSpeed;
            double verticalSpeed = Config.darkSteelGliderVerticalSpeed;
            if (player.func_70051_ag()) {
                verticalSpeed = Config.darkSteelGliderVerticalSpeedSprinting;
            }
            Vector3d look = Util.getLookVecEio(player);
            Vector3d side = new Vector3d();
            side.cross(new Vector3d(0.0, 1.0, 0.0), look);
            Vector3d playerPos = new Vector3d(player.field_70169_q, player.field_70167_r, player.field_70166_s);
            Vector3d b = new Vector3d(playerPos);
            b.y += 1.0;
            Vector3d c = new Vector3d(playerPos);
            c.add(side);
            Vector4d plane = new Vector4d();
            VecmathUtil.computePlaneEquation(playerPos, b, c, plane);
            double dist = Math.abs(VecmathUtil.distanceFromPointToPlane(plane, new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)));
            double minDist = 0.15;
            if (dist < minDist) {
                double dropRate = minDist * 10.0 - dist * 10.0;
                verticalSpeed += verticalSpeed * dropRate * 8.0;
                horizontalSpeed -= 0.02 * dropRate;
            }
            double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            player.field_70159_w += x;
            player.field_70179_y += z;
            player.field_70181_x = verticalSpeed;
            player.field_70143_R = 0.0f;
        }
    }

    public boolean isGliderUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_71124_b(3);
        GliderUpgrade glideUpgrade = GliderUpgrade.loadFromItem(chestPlate);
        return glideUpgrade != null;
    }

    private void updateSword(EntityPlayer player) {
        if (ItemDarkSteelSword.isEquipped(player)) {
            IAttributeInstance attackInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
            attackInst.func_111124_b(this.swordDamageModifierPowered);
            ItemStack sword = player.func_71045_bC();
            if (Config.darkSteelSwordPowerUsePerHit <= 0 || EnderIO.itemDarkSteelSword.getEnergyStored(sword) >= Config.darkSteelSwordPowerUsePerHit) {
                attackInst.func_111121_a(this.swordDamageModifierPowered);
            }
        }
    }

    private void updateSpeed(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || !player.field_70122_E) {
            return;
        }
        IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (moveInst.func_111127_a(this.walkModifiers[0].func_111167_a()) != null) {
            moveInst.func_111124_b(this.walkModifiers[0]);
        } else if (moveInst.func_111127_a(this.sprintModifiers[0].func_111167_a()) != null) {
            moveInst.func_111124_b(this.sprintModifiers[0]);
        }
        ItemStack leggings = player.func_71124_b(2);
        SpeedUpgrade speedUpgrade = SpeedUpgrade.loadFromItem(leggings);
        if (leggings != null && leggings.func_77973_b() == EnderIO.itemDarkSteelLeggings && speedUpgrade != null && this.isSpeedActive(player)) {
            double horzMovement = Math.abs(player.field_70140_Q - player.field_70141_P);
            double costModifier = player.func_70051_ag() ? (double)Config.darkSteelSprintPowerCost : (double)Config.darkSteelWalkPowerCost;
            costModifier += costModifier * (double)speedUpgrade.walkMultiplier;
            int cost = (int)(horzMovement * costModifier);
            int totalEnergy = this.getPlayerEnergy(player, EnderIO.itemDarkSteelLeggings);
            if (totalEnergy > 0) {
                this.usePlayerEnergy(player, EnderIO.itemDarkSteelLeggings, cost);
                if (player.func_70051_ag()) {
                    moveInst.func_111121_a(this.sprintModifiers[speedUpgrade.level - 1]);
                } else {
                    moveInst.func_111121_a(this.walkModifiers[speedUpgrade.level - 1]);
                }
            }
        }
    }

    private void updateStepHeightAndFallDistance(EntityPlayer player) {
        JumpUpgrade jumpUpgrade;
        int costedDistance;
        ItemStack boots = player.func_71124_b(1);
        if (boots != null && boots.func_77973_b() == EnderIO.itemDarkSteelBoots && (costedDistance = (int)player.field_70143_R) > 0) {
            int energyCost = costedDistance * Config.darkSteelFallDistanceCost;
            int totalEnergy = this.getPlayerEnergy(player, EnderIO.itemDarkSteelBoots);
            if (totalEnergy > 0 && totalEnergy >= energyCost) {
                this.usePlayerEnergy(player, EnderIO.itemDarkSteelBoots, energyCost);
                player.field_70143_R -= (float)costedDistance;
            }
        }
        if ((jumpUpgrade = JumpUpgrade.loadFromItem(boots)) != null && boots != null && boots.func_77973_b() == EnderIO.itemDarkSteelBoots && this.isStepAssistActive(player)) {
            player.field_70138_W = 1.0023f;
        } else if (player.field_70138_W == 1.0023f) {
            player.field_70138_W = 0.5001f;
        }
    }

    void usePlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor, int cost) {
        ItemStack stack;
        if (cost == 0) {
            return;
        }
        boolean extracted = false;
        int remaining = cost;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack2 : player.field_71071_by.field_70462_a) {
                if (stack2 == null || !(stack2.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem cont = (IEnergyContainerItem)stack2.func_77973_b();
                int used = cont.extractEnergy(stack2, remaining, false);
                extracted |= used > 0;
                if ((remaining -= used) > 0) continue;
                return;
            }
        }
        if (armor != null && remaining > 0 && (stack = player.field_71071_by.field_70460_b[3 - armor.field_77881_a]) != null) {
            int used = armor.extractEnergy(stack, remaining, false);
            extracted |= used > 0;
        }
    }

    private int getPlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor) {
        int res = 0;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem cont = (IEnergyContainerItem)stack.func_77973_b();
                res += cont.extractEnergy(stack, Integer.MAX_VALUE, true);
            }
        }
        if (armor != null) {
            ItemStack stack = player.field_71071_by.field_70460_b[3 - armor.field_77881_a];
            res = armor.getEnergyStored(stack);
        }
        return res;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            MovementInput input = player.field_71158_b;
            if (input.field_78901_c && !this.wasJumping) {
                this.doJump(player);
            } else if (input.field_78901_c && this.jumpCount < 3 && this.ticksSinceLastJump > 5) {
                this.doJump(player);
            }
            boolean bl = this.wasJumping = !player.field_70122_E;
            if (!this.wasJumping) {
                this.jumpCount = 0;
            }
            ++this.ticksSinceLastJump;
            this.updateNightvision((EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doJump(EntityClientPlayerMP player) {
        ItemStack boots = player.func_71124_b(1);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadFromItem(boots);
        if (jumpUpgrade == null || boots == null || boots.func_77973_b() != EnderIO.itemDarkSteelBoots) {
            return;
        }
        int requiredPower = Config.darkSteelBootsJumpPowerCost * (int)Math.pow(this.jumpCount + 1, 2.5);
        int availablePower = this.getPlayerEnergy((EntityPlayer)player, EnderIO.itemDarkSteelBoots);
        if (availablePower > 0 && requiredPower <= availablePower && this.jumpCount < jumpUpgrade.level) {
            ++this.jumpCount;
            player.field_70181_x += 0.15 * Config.darkSteelBootsJumpModifier * (double)this.jumpCount;
            this.ticksSinceLastJump = 0;
            this.usePlayerEnergy((EntityPlayer)player, EnderIO.itemDarkSteelBoots, requiredPower);
            player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "EnderIO:ds.jump", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.75f, false);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerPacket(requiredPower, EnderIO.itemDarkSteelBoots.field_77881_a));
        }
    }

    private void updateNightvision(EntityPlayer player) {
        if (this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.func_76396_c(), 210, 0, true));
        }
        if (!this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            this.nightVisionActive = false;
            this.removeNightvision = true;
        }
        if (this.removeNightvision) {
            player.func_82170_o(Potion.field_76439_r.func_76396_c());
            this.removeNightvision = false;
        }
    }

    public boolean isNightVisionUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_71124_b(4);
        return NightVisionUpgrade.loadFromItem(helmet) != null;
    }

    public void setNightVisionActive(boolean isNightVisionActive) {
        if (this.nightVisionActive && !isNightVisionActive) {
            this.removeNightvision = true;
        }
        this.nightVisionActive = isNightVisionActive;
    }
}

