/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.gas.GasUtil;
import crazypants.enderio.conduit.me.MEUtil;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.item.ItemYetaWrench;
import java.awt.Point;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class YetaWrenchOverlayRenderer {
    private ItemYetaWrench wrench;
    private IconEIO[] onIcons;
    private IconEIO[] offIcons;
    private Point[] iconOffsets;
    private Map<ConduitDisplayMode, Integer> indices = new EnumMap<ConduitDisplayMode, Integer>(ConduitDisplayMode.class);

    public YetaWrenchOverlayRenderer(ItemYetaWrench wrench) {
        this.wrench = wrench;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        ItemStack equippedWrench = this.getEquippedWrench();
        if (equippedWrench != null && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            this.doRenderOverlay(event, equippedWrench);
        }
    }

    private ItemStack getEquippedWrench() {
        ItemStack equipped = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
        if (equipped != null && equipped.func_77973_b() == this.wrench) {
            return equipped;
        }
        return null;
    }

    private void doRenderOverlay(RenderGameOverlayEvent event, ItemStack equippedWrench) {
        this.initIcons();
        ConduitDisplayMode mode = ConduitDisplayMode.getDisplayMode(equippedWrench);
        ScaledResolution res = event.resolution;
        double offsetX = 16.0;
        double offsetY = res.func_78328_b() - 16;
        if (mode == ConduitDisplayMode.ALL) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            this.renderAll(this.onIcons, offsetX, offsetY);
            return;
        }
        float c = 0.6f;
        GL11.glColor4f((float)c, (float)c, (float)c, (float)0.33f);
        this.renderAll(this.offIcons, offsetX, offsetY);
        if (this.indices.containsKey((Object)mode)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            int index = this.indices.get((Object)mode);
            Point p = this.iconOffsets[index];
            this.onIcons[index].renderIcon(offsetX + (double)p.x, offsetY + (double)p.y, 16.0, 16.0, 0.0, true);
        }
    }

    private void renderAll(IconEIO[] icons, double offsetX, double offsetY) {
        int i = 0;
        for (Point p : this.iconOffsets) {
            icons[i].renderIcon(offsetX + (double)p.x, offsetY + (double)p.y, 16.0, 16.0, 0.0, true);
            ++i;
        }
    }

    private void initIcons() {
        int numIcons = this.getNumConduitsEnabled();
        if (this.onIcons != null && this.onIcons.length == numIcons) {
            return;
        }
        boolean meEnabled = MEUtil.isMEEnabled();
        boolean gasEnabled = GasUtil.isGasConduitEnabled();
        this.onIcons = new IconEIO[numIcons];
        this.offIcons = new IconEIO[numIcons];
        this.iconOffsets = new Point[numIcons];
        this.indices.put(ConduitDisplayMode.POWER, 0);
        this.onIcons[0] = IconEIO.WRENCH_OVERLAY_POWER;
        this.offIcons[0] = IconEIO.WRENCH_OVERLAY_POWER_OFF;
        this.indices.put(ConduitDisplayMode.REDSTONE, 1);
        this.onIcons[1] = IconEIO.WRENCH_OVERLAY_REDSTONE;
        this.offIcons[1] = IconEIO.WRENCH_OVERLAY_REDSTONE_OFF;
        this.indices.put(ConduitDisplayMode.FLUID, 2);
        this.onIcons[2] = IconEIO.WRENCH_OVERLAY_FLUID;
        this.offIcons[2] = IconEIO.WRENCH_OVERLAY_FLUID_OFF;
        this.indices.put(ConduitDisplayMode.ITEM, 3);
        this.onIcons[3] = IconEIO.WRENCH_OVERLAY_ITEM;
        this.offIcons[3] = IconEIO.WRENCH_OVERLAY_ITEM_OFF;
        if (meEnabled) {
            this.indices.put(ConduitDisplayMode.ME, 4);
            this.onIcons[4] = IconEIO.WRENCH_OVERLAY_ME;
            this.offIcons[4] = IconEIO.WRENCH_OVERLAY_ME_OFF;
        }
        if (gasEnabled) {
            int index = meEnabled ? 5 : 4;
            this.indices.put(ConduitDisplayMode.GAS, index);
            this.onIcons[index] = IconEIO.WRENCH_OVERLAY_GAS;
            this.offIcons[index] = IconEIO.WRENCH_OVERLAY_GAS_OFF;
        }
        int xOffset = numIcons == 5 ? 8 : 0;
        this.iconOffsets[0] = new Point(xOffset, -32);
        this.iconOffsets[1] = new Point(xOffset + 16, -32);
        xOffset = 0;
        this.iconOffsets[2] = new Point(xOffset, -16);
        this.iconOffsets[3] = new Point(xOffset + 16, -16);
        if (numIcons == 5) {
            this.iconOffsets[4] = new Point(xOffset + 32, -16);
        } else if (numIcons == 6) {
            this.iconOffsets[4] = new Point(xOffset + 32, -32);
            this.iconOffsets[5] = new Point(xOffset + 32, -16);
        }
    }

    private int getNumConduitsEnabled() {
        boolean meEnabled = MEUtil.isMEEnabled();
        boolean gasEnabled = GasUtil.isGasConduitEnabled();
        return 4 + (meEnabled ? 1 : 0) + (gasEnabled ? 1 : 0);
    }
}

