/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.GogglesOfRevealingUpgrade;
import crazypants.enderio.item.darksteel.JumpUpgrade;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.SpeedUpgrade;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class KeyTracker {
    public static KeyTracker instance = new KeyTracker();
    private KeyBinding glideKey = new KeyBinding("Glider Toggle", 34, "Dark Steel Armor");
    private boolean isGlideActive = false;
    private KeyBinding soundDetectorKey;
    private boolean isSoundDectorActive = false;
    private KeyBinding nightVisionKey;
    private boolean isNightVisionActive = false;
    private KeyBinding stepAssistKey;
    private boolean isStepAssistActive = true;
    private KeyBinding speedKey;
    private boolean isSpeedActive = true;
    private KeyBinding gogglesKey;
    private KeyBinding yetaWrenchMode;

    public KeyTracker() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.glideKey);
        this.soundDetectorKey = new KeyBinding("Sound Locator", 38, "Dark Steel Armor");
        ClientRegistry.registerKeyBinding((KeyBinding)this.soundDetectorKey);
        this.nightVisionKey = new KeyBinding("Night Vision", 25, "Dark Steel Armor");
        ClientRegistry.registerKeyBinding((KeyBinding)this.nightVisionKey);
        this.gogglesKey = new KeyBinding("Goggles of Revealing", 19, "Dark Steel Armor");
        ClientRegistry.registerKeyBinding((KeyBinding)this.gogglesKey);
        this.stepAssistKey = new KeyBinding("Step Assist", 0, "Dark Steel Armor");
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepAssistKey);
        this.speedKey = new KeyBinding("Speed", 0, "Dark Steel Armor");
        ClientRegistry.registerKeyBinding((KeyBinding)this.speedKey);
        this.yetaWrenchMode = new KeyBinding("Yeta Wrench Mode", 21, "Tools");
        ClientRegistry.registerKeyBinding((KeyBinding)this.yetaWrenchMode);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.handleGlide();
        this.handleSoundDetector();
        this.handleNightVision();
        this.handleYetaWrench();
        this.handleGoggles();
        this.handleStepAssist();
        this.handleSpeed();
    }

    private void handleSpeed() {
        if (!SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.speedKey.func_151470_d()) {
            this.isSpeedActive = !this.isSpeedActive;
            String message = this.isSpeedActive ? Lang.localize("darksteel.upgrade.speed.enabled") : Lang.localize("darksteel.upgrade.speed.disabled");
            Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            DarkSteelController.instance.setSpeedActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.isSpeedActive);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.SPEED, this.isSpeedActive));
        }
    }

    private void handleStepAssist() {
        if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.stepAssistKey.func_151470_d()) {
            this.isStepAssistActive = !this.isStepAssistActive;
            String message = this.isStepAssistActive ? Lang.localize("darksteel.upgrade.stepAssist.enabled") : Lang.localize("darksteel.upgrade.stepAssist.disabled");
            Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            DarkSteelController.instance.setStepAssistActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.isStepAssistActive);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.STEP_ASSIST, this.isStepAssistActive));
        }
    }

    private void handleGoggles() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (!GogglesOfRevealingUpgrade.isUpgradeEquipped((EntityPlayer)player)) {
            return;
        }
        if (this.gogglesKey.func_151470_d()) {
            EnderIO.itemDarkSteelHelmet.setGogglesUgradeActive(!EnderIO.itemDarkSteelHelmet.isGogglesUgradeActive());
        }
    }

    private void handleYetaWrench() {
        if (!this.yetaWrenchMode.func_151468_f()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return;
        }
        if (equipped.func_77973_b() == EnderIO.itemYetaWench) {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
            if (curMode == null) {
                curMode = ConduitDisplayMode.ALL;
            }
            ConduitDisplayMode newMode = curMode.next();
            ConduitDisplayMode.setDisplayMode(equipped, newMode);
            PacketHandler.INSTANCE.sendToServer((IMessage)new YetaWrenchPacketProcessor(player.field_71071_by.field_70461_c, newMode));
        } else if (equipped.func_77973_b() == EnderIO.itemConduitProbe) {
            int newMeta = equipped.func_77960_j() == 0 ? 1 : 0;
            equipped.func_77964_b(newMeta);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
            player.func_71038_i();
        }
    }

    private void handleSoundDetector() {
        if (!this.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
            SoundDetector.instance.setEnabled(false);
            return;
        }
        if (this.soundDetectorKey.func_151470_d()) {
            this.isSoundDectorActive = !this.isSoundDectorActive;
            String message = this.isSoundDectorActive ? Lang.localize("darksteel.upgrade.sound.enabled") : Lang.localize("darksteel.upgrade.sound.disabled");
            Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            SoundDetector.instance.setEnabled(this.isSoundDectorActive);
        }
    }

    private void handleGlide() {
        if (!DarkSteelController.instance.isGliderUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.glideKey.func_151470_d()) {
            this.isGlideActive = !this.isGlideActive;
            String message = this.isGlideActive ? Lang.localize("darksteel.upgrade.glider.enabled") : Lang.localize("darksteel.upgrade.glider.disabled");
            Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            DarkSteelController.instance.setGlideActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.isGlideActive);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.GLIDE, this.isGlideActive));
        }
    }

    private void handleNightVision() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (!DarkSteelController.instance.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
            this.isNightVisionActive = false;
            return;
        }
        if (this.nightVisionKey.func_151470_d()) {
            boolean bl = this.isNightVisionActive = !this.isNightVisionActive;
            if (this.isNightVisionActive) {
                player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "EnderIO:ds.nightvision.on", 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f, false);
            } else {
                player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "EnderIO:ds.nightvision.off", 0.1f, 1.0f, false);
            }
            DarkSteelController.instance.setNightVisionActive(this.isNightVisionActive);
        }
    }

    public boolean isGlideActive() {
        return this.isGlideActive;
    }

    public boolean isSoundDetectorUpgradeEquipped(EntityClientPlayerMP player) {
        ItemStack helmet = player.func_71124_b(4);
        SoundDetectorUpgrade upgrade = SoundDetectorUpgrade.loadFromItem(helmet);
        return upgrade != null;
    }

    public KeyBinding getYetaWrenchMode() {
        return this.yetaWrenchMode;
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)instance);
    }
}

