/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSoulVessel
extends Item
implements IResourceTooltipProvider {
    private IIcon filledIcon;
    private List<String> blackList;

    public static ItemSoulVessel create() {
        ItemSoulVessel result = new ItemSoulVessel();
        result.init();
        return result;
    }

    protected ItemSoulVessel() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemSoulVessel.unlocalisedName);
        this.func_77625_d(64);
        this.blackList = new ArrayList<String>();
        for (String ent : Config.soulVesselBlackList) {
            this.blackList.add(ent);
        }
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemSoulVessel.unlocalisedName);
    }

    public void addEntityToBlackList(String entityName) {
        this.blackList.add(entityName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.field_77791_bV = IIconRegister2.func_94245_a("enderio:soulVessel");
        this.filledIcon = IIconRegister2.func_94245_a("enderio:soulVesselFilled");
    }

    public IIcon getIcon(ItemStack item, int arg1, EntityPlayer arg2, ItemStack arg3, int arg4) {
        if (this.containsSoul(item)) {
            return this.filledIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack item) {
        if (this.containsSoul(item)) {
            return this.filledIcon;
        }
        return this.field_77791_bV;
    }

    public boolean hasEffect(ItemStack item, int pass) {
        return this.containsSoul(item);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        boolean spaceClear;
        Entity mob;
        if (world.field_72995_K) {
            return true;
        }
        if (!this.containsSoul(itemstack)) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (itemstack.field_77994_a > 1) {
            return false;
        }
        NBTTagCompound root = itemstack.field_77990_d;
        if (root.func_74764_b("isStub")) {
            String entityId = root.func_74779_i("id");
            mob = EntityList.func_75620_a((String)entityId, (World)world);
        } else {
            mob = EntityList.func_75615_a((NBTTagCompound)root, (World)world);
        }
        if (mob == null) {
            return true;
        }
        mob.func_70020_e(root);
        Block blk = world.func_147439_a(x, y, z);
        double spawnX = (double)(x + Facing.field_71586_b[side]) + 0.5;
        double spawnY = y + Facing.field_71587_c[side];
        double spawnZ = (double)(z + Facing.field_71585_d[side]) + 0.5;
        if (side == ForgeDirection.UP.ordinal() && (blk instanceof BlockFence || blk instanceof BlockWall)) {
            spawnY += 0.5;
        }
        mob.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        boolean bl = spaceClear = world.func_72855_b(mob.field_70121_D) && world.func_72945_a(mob, mob.field_70121_D).isEmpty();
        if (!spaceClear) {
            return false;
        }
        world.func_72838_d(mob);
        if (mob instanceof EntityLiving) {
            ((EntityLiving)mob).func_70642_aH();
        }
        Entity riddenByEntity = mob.field_70153_n;
        while (riddenByEntity != null) {
            riddenByEntity.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d(riddenByEntity);
            if (riddenByEntity instanceof EntityLiving) {
                ((EntityLiving)riddenByEntity).func_70642_aH();
            }
            riddenByEntity = riddenByEntity.field_70153_n;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            itemstack.func_77982_d(null);
        }
        return true;
    }

    public boolean func_111207_a(ItemStack item, EntityPlayer player, EntityLivingBase entity) {
        boolean isCreative;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        boolean bl = isCreative = player != null && player.field_71075_bZ.field_75098_d;
        if (this.containsSoul(item) && !isCreative) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return false;
        }
        String entityId = EntityList.func_75621_b((Entity)entity);
        if (this.isBlackListed(entityId)) {
            return false;
        }
        if (!Config.soulVesselCapturesBosses && entity instanceof IBossDisplayData) {
            return false;
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74778_a("id", entityId);
        entity.func_70109_d(root);
        ItemStack capturedMobVessel = new ItemStack((Item)EnderIO.itemSoulVessel);
        player.func_71038_i();
        if (!isCreative) {
            entity.func_70106_y();
            if (entity.field_70128_L) {
                capturedMobVessel.func_77982_d(root);
                --item.field_77994_a;
                if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                    entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, capturedMobVessel));
                }
                player.func_70062_b(0, item);
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                return true;
            }
        } else {
            capturedMobVessel.func_77982_d(root);
            if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, capturedMobVessel));
            }
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            return true;
        }
        return false;
    }

    public ItemStack createVesselWithEntityStub(String entityId) {
        NBTTagCompound root = new NBTTagCompound();
        root.func_74778_a("id", entityId);
        root.func_74757_a("isStub", true);
        ItemStack res = new ItemStack((Item)this);
        res.field_77990_d = root;
        return res;
    }

    public ItemStack createVesselWithEntity(Entity ent) {
        String entityId = EntityList.func_75621_b((Entity)ent);
        NBTTagCompound root = new NBTTagCompound();
        root.func_74778_a("id", entityId);
        ent.func_70109_d(root);
        ItemStack res = new ItemStack((Item)this);
        res.field_77990_d = root;
        return res;
    }

    public boolean containsSoul(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() != this) {
            return false;
        }
        return item.field_77990_d != null && item.field_77990_d.func_74764_b("id");
    }

    public String getMobTypeFromStack(ItemStack item) {
        if (!this.containsSoul(item)) {
            return null;
        }
        if (item == null || item.field_77990_d == null || !item.field_77990_d.func_74764_b("id")) {
            return null;
        }
        return item.field_77990_d.func_74779_i("id");
    }

    private boolean isBlackListed(String entityId) {
        for (String str : this.blackList) {
            if (str == null || !str.equals(entityId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack != null) {
            String mobName = this.getMobTypeFromStack(par1ItemStack);
            if (mobName != null) {
                par3List.add(EntityUtil.getDisplayNameForEntity(mobName));
            } else {
                par3List.add("Empty");
            }
        }
    }
}

