/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.PacketIoMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.TravelController;
import crazypants.render.BoundingBox;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.IBlockAccessWrapper;
import crazypants.vecmath.Camera;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector4f;
import crazypants.vecmath.Vertex;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class IoConfigRenderer {
    protected static final RenderBlocks RB = new RenderBlocks();
    private boolean dragging = false;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private double distance;
    private long initTime;
    private Minecraft mc = Minecraft.func_71410_x();
    private World world;
    private final Vector3d origin;
    private final Vector3d eye;
    private final Camera camera;
    private final Matrix4d pitchRot;
    private final Matrix4d yawRot;
    public BlockCoord originBC;
    private List<BlockCoord> configurables;
    private List<BlockCoord> neighbours;
    private SelectedFace selection;
    private boolean renderNeighbours;
    private boolean inNeigButBounds;

    public IoConfigRenderer(IIoConfigurable configuarble) {
        this(Collections.singletonList(configuarble.getLocation()));
    }

    public IoConfigRenderer(List<BlockCoord> configurables) {
        Vector3d size;
        Vector3d c;
        this.world = this.mc.field_71439_g.field_70170_p;
        this.origin = new Vector3d();
        this.eye = new Vector3d();
        this.camera = new Camera();
        this.pitchRot = new Matrix4d();
        this.yawRot = new Matrix4d();
        this.configurables = new ArrayList<BlockCoord>();
        this.neighbours = new ArrayList<BlockCoord>();
        this.renderNeighbours = true;
        this.inNeigButBounds = false;
        this.configurables.addAll(configurables);
        if (configurables.size() == 1) {
            BlockCoord bc = configurables.get(0);
            c = new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
            size = new Vector3d(1.0, 1.0, 1.0);
        } else {
            Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (BlockCoord bc : configurables) {
                min.set(Math.min((double)bc.x, min.x), Math.min((double)bc.y, min.y), Math.min((double)bc.z, min.z));
                max.set(Math.max((double)bc.x, max.x), Math.max((double)bc.y, max.y), Math.max((double)bc.z, max.z));
            }
            size = new Vector3d(max);
            size.sub(min);
            size.scale(0.5);
            c = new Vector3d(min.x + size.x, min.y + size.y, min.z + size.z);
            size.scale(2.0);
        }
        this.originBC = new BlockCoord((int)c.x, (int)c.y, (int)c.z);
        this.origin.set(c);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        this.pitch = -this.mc.field_71439_g.field_70125_A;
        this.yaw = 180.0f - this.mc.field_71439_g.field_70177_z;
        this.distance = Math.max(Math.max(size.x, size.y), size.z) + 4.0;
        for (BlockCoord bc : configurables) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord loc = bc.getLocation(dir);
                if (configurables.contains(loc)) continue;
                this.neighbours.add(loc);
            }
        }
        this.world = this.mc.field_71439_g.field_70170_p;
        IoConfigRenderer.RB.field_147845_a = new InnerBA();
    }

    public void init() {
        this.initTime = System.currentTimeMillis();
    }

    public SelectedFace getSelection() {
        return this.selection;
    }

    public void handleMouseInput() {
        Vector3d end;
        Vector3d start;
        int y;
        if (Mouse.getEventButton() == 0) {
            this.dragging = Mouse.getEventButtonState();
        }
        if (this.dragging) {
            double dx = (double)Mouse.getEventDX() / (double)this.mc.field_71443_c;
            double dy = (double)Mouse.getEventDY() / (double)this.mc.field_71440_d;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42)) {
                this.distance -= dy * 15.0;
            } else {
                this.yaw = (float)((double)this.yaw - 4.0 * dx * 180.0);
                this.pitch = (float)((double)this.pitch + 2.0 * dy * 180.0);
                this.pitch = (float)VecmathUtil.clamp(this.pitch, -80.0, 80.0);
            }
        }
        this.distance -= (double)Mouse.getEventDWheel() * 0.01;
        this.distance = VecmathUtil.clamp(this.distance, 0.01, 200.0);
        long elapsed = System.currentTimeMillis() - this.initTime;
        int x = Mouse.getEventX();
        if (this.camera.getRayForPixel(x, y = Mouse.getEventY(), start = new Vector3d(), end = new Vector3d())) {
            end.scale(this.distance * 2.0);
            end.add(start);
            this.updateSelection(start, end);
        }
        if (!Mouse.getEventButtonState() && this.camera.isValid() && elapsed > 500L) {
            if (Mouse.getEventButton() == 1) {
                if (this.selection != null) {
                    this.selection.config.toggleIoModeForFace(this.selection.face);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketIoMode(this.selection.config, this.selection.face));
                }
            } else if (Mouse.getEventButton() == 0 && this.inNeigButBounds) {
                this.renderNeighbours = !this.renderNeighbours;
            }
        }
    }

    private void updateSelection(Vector3d start, Vector3d end) {
        TileEntity te;
        start.add(this.origin);
        end.add(this.origin);
        ArrayList<MovingObjectPosition> hits = new ArrayList<MovingObjectPosition>();
        for (BlockCoord bc : this.configurables) {
            MovingObjectPosition hit;
            Block block = this.world.func_147439_a(bc.x, bc.y, bc.z);
            if (block == null || (hit = block.func_149731_a(this.world, bc.x, bc.y, bc.z, Vec3.func_72443_a((double)start.x, (double)start.y, (double)start.z), Vec3.func_72443_a((double)end.x, (double)end.y, (double)end.z))) == null) continue;
            hits.add(hit);
        }
        this.selection = null;
        MovingObjectPosition hit = IoConfigRenderer.getClosestHit(Vec3.func_72443_a((double)start.x, (double)start.y, (double)start.z), hits);
        if (hit != null && (te = this.world.func_147438_o(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) instanceof IIoConfigurable) {
            IIoConfigurable configuarble = (IIoConfigurable)te;
            ForgeDirection face = ForgeDirection.getOrientation((int)hit.field_72310_e);
            this.selection = new SelectedFace(configuarble, face);
        }
    }

    public static MovingObjectPosition getClosestHit(Vec3 origin, Collection<MovingObjectPosition> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        MovingObjectPosition closest = null;
        for (MovingObjectPosition hit : candidates) {
            double lengthSquared;
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = hit;
        }
        return closest;
    }

    public void drawScreen(int par1, int par2, float partialTick, Rectangle vp, Rectangle parentBounds) {
        if (!this.updateCamera(partialTick, vp.x, vp.y, vp.width, vp.height)) {
            return;
        }
        this.applyCamera(partialTick);
        TravelController.instance.setSelectionEnabled(false);
        this.renderScene();
        TravelController.instance.setSelectionEnabled(true);
        this.renderSelection();
        this.renderOverlay(par1, par2);
    }

    private void renderSelection() {
        if (this.selection == null) {
            return;
        }
        BoundingBox bb = new BoundingBox(this.selection.config.getLocation());
        IIcon icon = EnderIO.blockAlloySmelter.selectedFaceIcon;
        List<Vertex> corners = bb.getCornersWithUvForFace(this.selection.face, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        RenderUtil.bindBlockTexture();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        Tessellator.field_78398_a.func_78373_b(trans.x, trans.y, trans.z);
        RenderUtil.addVerticesToTesselator(corners);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
    }

    private void renderOverlay(int mx, int my) {
        Rectangle vp = this.camera.getViewport();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int vpx = vp.x / scaledresolution.func_78325_e();
        int vph = vp.height / scaledresolution.func_78325_e();
        int vpw = vp.width / scaledresolution.func_78325_e();
        int vpy = (int)((float)(vp.y + vp.height - 4) / (float)scaledresolution.func_78325_e());
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)vpx, (float)vpy, (float)-2000.0f);
        GL11.glDisable((int)2896);
        int x = vpw - 16;
        int y = vph - 16;
        if ((mx -= vpx) >= x && (double)mx <= (double)x + IconEIO.IO_WHATSIT.width && (my -= vpy) >= y && (double)my <= (double)y + IconEIO.IO_WHATSIT.height) {
            RenderUtil.renderQuad2D((double)x, (double)y, 0.0, IconEIO.IO_WHATSIT.width, IconEIO.IO_WHATSIT.height, new Vector4f(0.4f, 0.4f, 0.4f, 0.6f));
            this.inNeigButBounds = true;
        } else {
            this.inNeigButBounds = false;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO.IO_WHATSIT.renderIcon(x, y, true);
        if (this.selection != null) {
            IconEIO ioIcon = null;
            IoMode mode = this.selection.config.getIoMode(this.selection.face);
            if (mode == IoMode.PULL) {
                ioIcon = IconEIO.INPUT_SMALL_INV;
            } else if (mode == IoMode.PUSH) {
                ioIcon = IconEIO.OUTPUT_SMALL_INV;
            } else if (mode == IoMode.PUSH_PULL) {
                ioIcon = IconEIO.INPUT_OUTPUT;
            } else if (mode == IoMode.DISABLED) {
                ioIcon = IconEIO.DISABLED;
            }
            y = vph - this.mc.field_71466_p.field_78288_b - 2;
            this.mc.field_71466_p.func_78276_b(this.getLabelForMode(mode), 4, y, ColorUtil.getRGB(Color.white));
            if (ioIcon != null) {
                int w = this.mc.field_71466_p.func_78256_a(mode.getLocalisedName());
                double xd = ((double)w - ioIcon.width) / 2.0;
                xd = Math.max(0, w);
                xd /= 2.0;
                xd += 4.0;
                ioIcon.renderIcon(xd /= (double)scaledresolution.func_78325_e(), y - this.mc.field_71466_p.field_78288_b - 2, true);
            }
        }
    }

    protected String getLabelForMode(IoMode mode) {
        return mode.getLocalisedName();
    }

    private void renderScene() {
        int pass;
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        RenderHelper.func_74518_a();
        this.mc.field_71460_t.func_78483_a(0.0);
        RenderUtil.bindBlockTexture();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        for (pass = 0; pass < 1; ++pass) {
            this.setGlStateForPass(pass, false);
            this.doWorldRenderPass(trans, this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doWorldRenderPass(trans, this.neighbours, pass);
        }
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2896);
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.z - this.eye.z;
        TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.eye.z;
        for (pass = 0; pass < 2; ++pass) {
            this.setGlStateForPass(pass, false);
            this.doTileEntityRenderPass(this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doTileEntityRenderPass(this.neighbours, pass);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0, false);
    }

    private void doTileEntityRenderPass(List<BlockCoord> blocks, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        for (BlockCoord bc : blocks) {
            TileEntity tile = this.world.func_147438_o(bc.x, bc.y, bc.z);
            if (tile == null) continue;
            Vector3d at = new Vector3d(this.eye.x, this.eye.y, this.eye.z);
            at.x += (double)bc.x - this.origin.x;
            at.y += (double)bc.y - this.origin.y;
            at.z += (double)bc.z - this.origin.z;
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, at.x, at.y, at.z, 0.0f);
        }
    }

    private void doWorldRenderPass(Vector3d trans, List<BlockCoord> blocks, int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78373_b(trans.x, trans.y, trans.z);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        for (BlockCoord bc : blocks) {
            Block block = this.world.func_147439_a(bc.x, bc.y, bc.z);
            if (block == null || !block.canRenderInPass(pass)) continue;
            IoConfigRenderer.RB.field_147837_f = true;
            RB.func_147753_b(true);
            RB.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            try {
                RB.func_147805_b(block, bc.x, bc.y, bc.z);
            }
            catch (Exception e) {}
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
    }

    private void setGlStateForPass(int pass, boolean isNeighbour) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isNeighbour) {
            float alpha = 0.8f;
            if (pass == 0) {
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)2884);
                GL11.glBlendFunc((int)32771, (int)32769);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glDepthMask((boolean)true);
            } else {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)32769);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glDepthMask((boolean)false);
            }
            return;
        }
        if (pass == 0) {
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }

    private boolean updateCamera(float partialTick, int vpx, int vpy, int vpw, int vph) {
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(this.yaw));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera(float partialTick) {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        RenderUtil.loadMatrix(this.camera.getTransposeProjectionMatrix());
        GL11.glMatrixMode((int)5888);
        RenderUtil.loadMatrix(this.camera.getTransposeViewMatrix());
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    private class InnerBA
    extends IBlockAccessWrapper {
        InnerBA() {
            super((IBlockAccess)IoConfigRenderer.this.world);
        }

        @Override
        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            return false;
        }

        @Override
        public boolean func_147437_c(int var1, int var2, int var3) {
            if (!IoConfigRenderer.this.configurables.contains(new BlockCoord(var1, var2, var3))) {
                return false;
            }
            return super.func_147437_c(var1, var2, var3);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int func_72802_i(int var1, int var2, int var3, int var4) {
            return 0xF000F0;
        }

        @Override
        public Block func_147439_a(int var1, int var2, int var3) {
            if (!IoConfigRenderer.this.configurables.contains(new BlockCoord(var1, var2, var3))) {
                return Blocks.field_150350_a;
            }
            return super.func_147439_a(var1, var2, var3);
        }
    }

    public static class SelectedFace {
        public IIoConfigurable config;
        public ForgeDirection face;

        public SelectedFace(IIoConfigurable config, ForgeDirection face) {
            this.config = config;
            this.face = face;
        }

        public String toString() {
            return "SelectedFace [config=" + this.config + ", face=" + this.face + "]";
        }
    }
}

