/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import cofh.api.tileentity.IRedstoneControl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.tool.ToolUtil;
import crazypants.render.BoundingBox;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import crazypants.util.DyeColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InsulatedRedstoneConduit
extends RedstoneConduit
implements IInsulatedRedstoneConduit {
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private static final List<Block> CONECTABLE_BLOCKS = Arrays.asList(Blocks.field_150379_bu, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150451_bX, Blocks.field_150367_z, Blocks.field_150442_at, Blocks.field_150471_bO, Blocks.field_150430_aB, Blocks.field_150452_aw, Blocks.field_150456_au, Blocks.field_150409_cd, Blocks.field_150453_bW, Blocks.field_150483_bI, Blocks.field_150318_D, Blocks.field_150447_bR);
    private static Map<Class<?>, Boolean> CONNECTABLE_CLASSES = null;
    private Map<ForgeDirection, ConnectionMode> forcedConnections = new HashMap<ForgeDirection, ConnectionMode>();
    private Map<ForgeDirection, DyeColor> signalColors = new HashMap<ForgeDirection, DyeColor>();
    private Map<ForgeDirection, Boolean> signalStrengths = new HashMap<ForgeDirection, Boolean>();

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(IIconRegister register) {
                ICONS.put("enderio:redstoneInsulatedConduitCoreOff", register.func_94245_a("enderio:redstoneInsulatedConduitCoreOff"));
                ICONS.put("enderio:redstoneInsulatedConduitCoreOn", register.func_94245_a("enderio:redstoneInsulatedConduitCoreOn"));
                ICONS.put("enderio:redstoneInsulatedConduit", register.func_94245_a("enderio:redstoneInsulatedConduit"));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    public static void addConnectableBlock(NBTTagCompound nbt) {
        if (nbt == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a redstone connectable using a null NBT");
            return;
        }
        boolean connectable = true;
        if (nbt.func_74764_b("isConnectable")) {
            connectable = nbt.func_74767_n("isConnectable");
        }
        String className = nbt.func_74779_i("className");
        InsulatedRedstoneConduit.addConnectableInterface(className, connectable);
    }

    public static void addConnectableBlock(Block block) {
        if (block == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a redstone connectable using a null Block");
            return;
        }
        CONECTABLE_BLOCKS.add(block);
    }

    public static void addConnectableInterface(String className, boolean connectable) {
        try {
            Class<?> clz = Class.forName(className);
            InsulatedRedstoneConduit.addConnectableInterface(clz, connectable);
        }
        catch (Exception e) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register " + className + " as connectable but it could not be loaded");
        }
    }

    public static void addConnectableInterface(Class<?> clazz, boolean connectable) {
        if (clazz == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a null class as a connectable");
            return;
        }
        InsulatedRedstoneConduit.getConnectableInterfaces().put(clazz, connectable);
    }

    private static Map<Class<?>, Boolean> getConnectableInterfaces() {
        if (CONNECTABLE_CLASSES == null) {
            CONNECTABLE_CLASSES = new HashMap();
            CONNECTABLE_CLASSES.put(IRedstoneControl.class, false);
            try {
                Class<?> conInterface = Class.forName("powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection");
                CONNECTABLE_CLASSES.put(conInterface, false);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class<?> ccInterface = Class.forName("dan200.computercraft.shared.computer.blocks.IComputerTile");
                CONNECTABLE_CLASSES.put(ccInterface, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return CONNECTABLE_CLASSES;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (!world.field_72995_K) {
            DyeColor col = DyeColor.getColorFromDye(player.func_71045_bC());
            if (col != null && res.component != null) {
                this.setSignalColor(res.component.dir, col);
                return true;
            }
            if (ToolUtil.isToolEquipped(player) && res != null && res.component != null) {
                BlockCoord loc;
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                boolean colorHit = false;
                if (all != null && this.containsExternalConnection(connDir)) {
                    for (RaytraceResult rtr : all) {
                        if (rtr == null || rtr.component == null || !"ColorController".equals(rtr.component.data)) continue;
                        colorHit = true;
                    }
                }
                if (colorHit) {
                    this.setSignalColor(connDir, DyeColor.getNext(this.getSignalColor(connDir)));
                    return true;
                }
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    loc = this.getLocation().getLocation(faceHit);
                    Block id = world.func_147439_a(loc.x, loc.y, loc.z);
                    if (id == EnderIO.blockConduitBundle) {
                        IRedstoneConduit neighbour = ConduitUtil.getConduit((IBlockAccess)world, loc.x, loc.y, loc.z, IRedstoneConduit.class);
                        if (neighbour != null && neighbour.getConnectionMode(faceHit.getOpposite()) == ConnectionMode.DISABLED) {
                            neighbour.setConnectionMode(faceHit.getOpposite(), ConnectionMode.NOT_SET);
                        }
                        this.setConnectionMode(faceHit, ConnectionMode.NOT_SET);
                        return ConduitUtil.joinConduits(this, faceHit);
                    }
                    this.forceConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                if (this.externalConnections.contains(connDir)) {
                    if (this.network != null) {
                        this.network.destroyNetwork();
                    }
                    this.externalConnectionRemoved(connDir);
                    this.forceConnectionMode(connDir, ConnectionMode.DISABLED);
                    return true;
                }
                if (this.containsConduitConnection(connDir)) {
                    loc = this.getLocation().getLocation(connDir);
                    IRedstoneConduit neighbour = ConduitUtil.getConduit((IBlockAccess)this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IRedstoneConduit.class);
                    if (neighbour != null) {
                        if (this.network != null) {
                            this.network.destroyNetwork();
                        }
                        if (neighbour.getNetwork() != null) {
                            neighbour.getNetwork().destroyNetwork();
                        }
                        neighbour.conduitConnectionRemoved(connDir.getOpposite());
                        this.conduitConnectionRemoved(connDir);
                        this.updateNetwork();
                        neighbour.updateNetwork();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        this.setSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("signalColor")]);
        this.setOutputStrength(dir, dataRoot.func_74767_n("signalStrong"));
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("signalColor", (short)this.getSignalColor(dir).ordinal());
        dataRoot.func_74757_a("signalStrong", this.isOutputStrong(dir));
    }

    @Override
    public void forceConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        if (mode == ConnectionMode.IN_OUT) {
            this.setConnectionMode(dir, mode);
            this.forcedConnections.put(dir, mode);
            this.onAddedToBundle();
            Set<Signal> newSignals = this.getNetworkInputs(dir);
            if (this.network != null) {
                this.network.addSignals(newSignals);
                this.network.notifyNeigborsOfSignals();
            }
        } else {
            Set<Signal> signals = this.getNetworkInputs(dir);
            this.setConnectionMode(dir, mode);
            this.forcedConnections.put(dir, mode);
            this.onAddedToBundle();
            if (this.network != null) {
                this.network.removeSignals(signals);
                this.network.notifyNeigborsOfSignals();
            }
        }
    }

    @Override
    public ConnectionMode getNextConnectionMode(ForgeDirection dir) {
        if (this.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
            return ConnectionMode.DISABLED;
        }
        return ConnectionMode.IN_OUT;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(ForgeDirection dir) {
        if (this.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
            return ConnectionMode.DISABLED;
        }
        return ConnectionMode.IN_OUT;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemRedstoneConduit, 1, 2);
    }

    @Override
    public Class<? extends IConduit> getCollidableType() {
        return IInsulatedRedstoneConduit.class;
    }

    @Override
    public void onInputsChanged(ForgeDirection side, int[] inputValues) {
    }

    @Override
    public void onInputChanged(ForgeDirection side, int inputValue) {
    }

    @Override
    public DyeColor getSignalColor(ForgeDirection dir) {
        DyeColor res = this.signalColors.get(dir);
        if (res == null) {
            return DyeColor.RED;
        }
        return res;
    }

    @Override
    public void setSignalColor(ForgeDirection dir, DyeColor col) {
        Set<Signal> toRemove = this.getNetworkInputs(dir);
        this.signalColors.put(dir, col);
        Set<Signal> toAdd = this.getNetworkInputs(dir);
        if (this.network != null) {
            this.network.removeSignals(toRemove);
            this.network.addSignals(toAdd);
            this.network.notifyNeigborsOfSignals();
        }
        this.setClientStateDirty();
    }

    @Override
    public boolean isOutputStrong(ForgeDirection dir) {
        if (this.signalStrengths.containsKey(dir)) {
            return this.signalStrengths.get(dir);
        }
        return false;
    }

    @Override
    public void setOutputStrength(ForgeDirection dir, boolean isStrong) {
        if (this.isOutputStrong(dir) != isStrong) {
            if (isStrong) {
                this.signalStrengths.put(dir, isStrong);
            } else {
                this.signalStrengths.remove(dir);
            }
            if (this.network != null) {
                this.network.notifyNeigborsOfSignals();
            }
        }
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreConnectionState) {
        if (ignoreConnectionState) {
            return true;
        }
        if (this.forcedConnections.get(direction) == ConnectionMode.DISABLED) {
            return false;
        }
        if (this.forcedConnections.get(direction) == ConnectionMode.IN_OUT) {
            return true;
        }
        BlockCoord loc = this.getLocation().getLocation(direction);
        World world = this.getBundle().getEntity().func_145831_w();
        Block block = world.func_147439_a(loc.x, loc.y, loc.z);
        TileEntity te = world.func_147438_o(loc.x, loc.y, loc.z);
        if (block == null || block == EnderIO.blockConduitBundle) {
            return false;
        }
        if (CONECTABLE_BLOCKS.contains(block)) {
            return true;
        }
        if (block instanceof IRedstoneConnectable) {
            return ((IRedstoneConnectable)block).shouldRedstoneConduitConnect(world, loc.x, loc.y, loc.z, direction);
        }
        if (te instanceof IRedstoneConnectable) {
            return ((IRedstoneConnectable)te).shouldRedstoneConduitConnect(world, loc.x, loc.y, loc.z, direction);
        }
        Map<Class<?>, Boolean> connectableInterfaces = InsulatedRedstoneConduit.getConnectableInterfaces();
        for (Class<?> connectable : connectableInterfaces.keySet()) {
            if ((te == null || !connectable.isAssignableFrom(te.getClass())) && !connectable.isAssignableFrom(block.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSpecialConnection(ForgeDirection dir) {
        BlockCoord loc = this.getLocation().getLocation(dir);
        Block block = this.getBundle().getEntity().func_145831_w().func_147439_a(loc.x, loc.y, loc.z);
        World world = this.getBundle().getEntity().func_145831_w();
        TileEntity te = world.func_147438_o(loc.x, loc.y, loc.z);
        Map<Class<?>, Boolean> connectableInterfaces = InsulatedRedstoneConduit.getConnectableInterfaces();
        for (Class<?> connectable : connectableInterfaces.keySet()) {
            if ((te == null || !connectable.isAssignableFrom(te.getClass())) && (block == null || !connectable.isAssignableFrom(block.getClass()))) continue;
            return connectableInterfaces.get(connectable);
        }
        return false;
    }

    @Override
    public int isProvidingWeakPower(ForgeDirection toDirection) {
        if (this.getConnectionMode(toDirection.getOpposite()) != ConnectionMode.IN_OUT) {
            return 0;
        }
        return super.isProvidingWeakPower(toDirection);
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection toDirection) {
        if (this.isOutputStrong(toDirection.getOpposite())) {
            return this.isProvidingWeakPower(toDirection);
        }
        return 0;
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.setConnectionMode(fromDirection, ConnectionMode.IN_OUT);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.setConnectionMode(fromDirection, ConnectionMode.NOT_SET);
    }

    @Override
    public Set<Signal> getNetworkOutputs(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return super.getNetworkOutputs(side);
        }
        ConnectionMode mode = this.getConnectionMode(side);
        if (this.network == null || mode != ConnectionMode.IN_OUT) {
            return Collections.emptySet();
        }
        Set<Signal> allSigs = this.network.getSignals();
        if (allSigs.isEmpty()) {
            return allSigs;
        }
        DyeColor col = this.getSignalColor(side);
        HashSet<Signal> result = new HashSet<Signal>();
        for (Signal signal : allSigs) {
            if (signal.color != col) continue;
            result.add(signal);
        }
        return result;
    }

    @Override
    public ConnectionMode getConnectionMode(ForgeDirection dir) {
        ConnectionMode res = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (res == null) {
            return ConnectionMode.NOT_SET;
        }
        return res;
    }

    @Override
    protected boolean acceptSignalsForDir(ForgeDirection dir) {
        return this.getConnectionMode(dir) == ConnectionMode.IN_OUT && super.acceptSignalsForDir(dir);
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == ForgeDirection.UNKNOWN) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IRedstoneConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return this.isActive() ? ICONS.get("enderio:redstoneInsulatedConduitCoreOn") : ICONS.get("enderio:redstoneInsulatedConduitCoreOff");
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.whiteTexture;
        }
        return ICONS.get("enderio:redstoneInsulatedConduit");
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return this.isActive() ? RedstoneConduit.ICONS.get("enderio:redstoneConduitTransmission") : RedstoneConduit.ICONS.get("enderio:redstoneConduit");
    }

    @Override
    protected boolean renderStub(ForgeDirection dir) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        int i;
        byte[] modes;
        super.writeToNBT(nbtRoot);
        if (this.forcedConnections.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ConnectionMode mode = this.forcedConnections.get(dir);
                modes[i] = mode != null ? (int)mode.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("forcedConnections", modes);
        }
        if (this.signalColors.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                DyeColor col = this.signalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
        if (this.signalStrengths.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                boolean isStrong = this.isOutputStrong(dir);
                modes[i] = isStrong ? (byte)1 : 0;
                ++i;
            }
            nbtRoot.func_74773_a("signalStrengths", modes);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.forcedConnections.clear();
        byte[] modes = nbtRoot.func_74770_j("forcedConnections");
        if (modes != null && modes.length == 6) {
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (modes[i] >= 0) {
                    this.forcedConnections.put(dir, ConnectionMode.values()[modes[i]]);
                }
                ++i;
            }
        }
        this.signalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (cols[i] >= 0) {
                    this.signalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
        this.signalStrengths.clear();
        byte[] strengths = nbtRoot.func_74770_j("signalStrengths");
        if (strengths != null && strengths.length == 6) {
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (strengths[i] > 0) {
                    this.signalStrengths.put(dir, true);
                }
                ++i;
            }
        }
    }
}

