/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.me;

import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.me.MEConduitGrid;
import crazypants.enderio.conduit.me.MEConduitNetwork;
import crazypants.enderio.tool.ToolUtil;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MEConduit
extends AbstractConduit
implements IMEConduit {
    protected MEConduitNetwork network;
    protected MEConduitGrid grid;
    public static IIcon[] coreTextures;
    public static IIcon[] longTextures;
    private boolean isDense;
    EnumSet<ForgeDirection> validConnections = EnumSet.copyOf(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));

    public MEConduit() {
        this(0);
    }

    public MEConduit(int itemDamage) {
        this.isDense = itemDamage == 1;
    }

    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(IIconRegister register) {
                coreTextures = new IIcon[2];
                longTextures = new IIcon[2];
                MEConduit.coreTextures[0] = register.func_94245_a("EnderIO:meConduitCore");
                MEConduit.coreTextures[1] = register.func_94245_a("EnderIO:meConduitCoreDense");
                MEConduit.longTextures[0] = register.func_94245_a("EnderIO:meConduit");
                MEConduit.longTextures[1] = register.func_94245_a("EnderIO:meConduitDense");
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    public static int getDamageForState(boolean isDense) {
        return isDense ? 1 : 0;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IMEConduit.class;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemMEConduit, 1, MEConduit.getDamageForState(this.isDense));
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (MEConduitNetwork)network;
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        NBTTagList list = new NBTTagList();
        for (ForgeDirection dir : this.validConnections) {
            NBTTagString name = new NBTTagString(dir.name());
            list.func_74742_a((NBTBase)name);
        }
        nbtRoot.func_74782_a("validConnections", (NBTBase)list);
        nbtRoot.func_74757_a("isDense", this.isDense);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        if (nbtRoot.func_74764_b("validConnections")) {
            this.validConnections.clear();
            NBTTagList connections = nbtRoot.func_150295_c("validConnections", 8);
            for (int i = 0; i < connections.func_74745_c(); ++i) {
                this.validConnections.add(ForgeDirection.valueOf((String)connections.func_150307_f(i)));
            }
        }
        this.isDense = nbtRoot.func_74767_n("isDense");
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public boolean canConnectToExternal(ForgeDirection dir, boolean ignoreConnectionMode) {
        World world = this.getBundle().getWorld();
        BlockCoord pos = this.getLocation();
        TileEntity te = world.func_147438_o(pos.x + dir.offsetX, pos.y + dir.offsetY, pos.z + dir.offsetZ);
        if (!ignoreConnectionMode && this.getConnectionMode(dir) == ConnectionMode.DISABLED) {
            return false;
        }
        if (te instanceof IPartHost) {
            IPart part = ((IPartHost)te).getPart(dir.getOpposite());
            if (part == null) {
                part = ((IPartHost)te).getPart(ForgeDirection.UNKNOWN);
                return part != null;
            }
            return part.getExternalFacingNode() != null;
        }
        if (te instanceof IGridHost) {
            return !(te instanceof TileConduitBundle) && ((IGridHost)te).getCableConnectionType(dir.getOpposite()) != AECableType.NONE;
        }
        return false;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        int state = MEConduit.getDamageForState(this.isDense);
        if (component.dir == ForgeDirection.UNKNOWN) {
            return coreTextures[state];
        }
        return longTextures[state];
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void updateEntity(World worldObj) {
        IGridNode node;
        if (this.grid == null) {
            this.grid = new MEConduitGrid(this);
        }
        if (this.getNode() == null && !worldObj.field_72995_K && (node = AEApi.instance().createGridNode((IGridBlock)this.grid)) != null) {
            this.getBundle().setGridNode(node);
            this.getNode().updateState();
        }
        super.updateEntity(worldObj);
    }

    @Override
    public ConnectionMode getNextConnectionMode(ForgeDirection dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    public ConnectionMode getConnectionMode(ForgeDirection dir) {
        return this.validConnections.contains(dir) ? ConnectionMode.IN_OUT : ConnectionMode.DISABLED;
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        if (mode == ConnectionMode.DISABLED) {
            this.validConnections.remove(dir);
        } else {
            this.validConnections.add(dir);
        }
        if (this.hasNode()) {
            this.getNode().updateState();
            this.getNode().getWorld().func_147471_g(this.getLocation().x, this.getLocation().y, this.getLocation().z);
        }
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit conduit) {
        if (conduit == null) {
            return false;
        }
        return conduit instanceof IMEConduit;
    }

    @Override
    public void conduitConnectionAdded(ForgeDirection fromDirection) {
        super.conduitConnectionAdded(fromDirection);
        this.validConnections.add(fromDirection);
    }

    @Override
    public void conduitConnectionRemoved(ForgeDirection fromDirection) {
        super.conduitConnectionRemoved(fromDirection);
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    protected void connectionsChanged() {
        super.connectionsChanged();
        this.onNodeChanged();
        if (this.getNode() != null) {
            this.getNode().updateState();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        super.onBlockActivated(player, res, all);
        if (ToolUtil.isToolEquipped(player) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
            ForgeDirection connDir = res.component.dir;
            ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
            if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                boolean retVal;
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                }
                if (retVal = ConduitUtil.joinConduits(this, faceHit)) {
                    this.onNodeChanged();
                }
                return retVal;
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                this.onNodeChanged();
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onNodeChanged() {
        boolean foundConnection = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getBundle().getLocation().getLocation(dir).getTileEntity(this.getBundle().getWorld());
            if (te == null || !(te instanceof IGridHost)) continue;
            IGridNode node = ((IGridHost)te).getGridNode(ForgeDirection.UNKNOWN);
            foundConnection |= this.validConnections.contains(dir);
            if (node == null) {
                node = ((IGridHost)te).getGridNode(dir.getOpposite());
            }
            if (node == null) continue;
            node.updateState();
        }
        if (!foundConnection && this.hasNode()) {
            this.getNode().destroy();
        }
    }

    @Override
    public void onAddedToBundle() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IMEConduit cond;
            TileEntity te = this.getLocation().getLocation(dir).getTileEntity(this.getBundle().getWorld());
            if (!(te instanceof TileConduitBundle) || (cond = ((TileConduitBundle)te).getConduit(IMEConduit.class)) == null) continue;
            cond.setConnectionMode(dir.getOpposite(), ConnectionMode.IN_OUT);
            ConduitUtil.joinConduits(cond, dir.getOpposite());
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void onRemovedFromBundle() {
        super.onRemovedFromBundle();
        this.getNode().destroy();
        this.getBundle().setGridNode(null);
    }

    @Override
    public MEConduitGrid getGrid() {
        return this.grid;
    }

    @Optional.Method(modid="appliedenergistics2")
    private IGridNode getNode() {
        return this.getBundle().getGridNode(null);
    }

    private boolean hasNode() {
        return this.getNode() != null;
    }

    @Override
    public EnumSet<ForgeDirection> getConnections() {
        Set<ForgeDirection> cons = this.getConduitConnections();
        cons.addAll(this.getExternalConnections());
        if (cons.isEmpty()) {
            return EnumSet.noneOf(ForgeDirection.class);
        }
        return EnumSet.copyOf(cons);
    }

    @Override
    public boolean isDense() {
        return this.isDense;
    }
}

