/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.tool.ToolUtil;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class EnderLiquidConduit
extends AbstractLiquidConduit {
    public static final String ICON_KEY = "enderio:liquidConduitEnder";
    public static final String ICON_CORE_KEY = "enderio:liquidConduitCoreEnder";
    public static final String ICON_EXTRACT_KEY = "enderio:liquidConduitAdvancedInput";
    public static final String ICON_INSERT_KEY = "enderio:liquidConduitAdvancedOutput";
    public static final String ICON_IN_OUT_KEY = "enderio:liquidConduitAdvancedInOut";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private EnderLiquidConduitNetwork network;
    private int ticksSinceFailedExtract;
    private final EnumMap<ForgeDirection, FluidFilter> outputFilters = new EnumMap(ForgeDirection.class);
    private final EnumMap<ForgeDirection, FluidFilter> inputFilters = new EnumMap(ForgeDirection.class);

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(IIconRegister register) {
                ICONS.put(EnderLiquidConduit.ICON_KEY, register.func_94245_a(EnderLiquidConduit.ICON_KEY));
                ICONS.put(EnderLiquidConduit.ICON_CORE_KEY, register.func_94245_a(EnderLiquidConduit.ICON_CORE_KEY));
                ICONS.put(EnderLiquidConduit.ICON_EXTRACT_KEY, register.func_94245_a(EnderLiquidConduit.ICON_EXTRACT_KEY));
                ICONS.put(EnderLiquidConduit.ICON_INSERT_KEY, register.func_94245_a(EnderLiquidConduit.ICON_INSERT_KEY));
                ICONS.put(EnderLiquidConduit.ICON_IN_OUT_KEY, register.func_94245_a(EnderLiquidConduit.ICON_IN_OUT_KEY));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemLiquidConduit, 1, 2);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit((IBlockAccess)this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!(n instanceof EnderLiquidConduit)) {
                        return false;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public FluidFilter getFilter(ForgeDirection dir, boolean isInput) {
        if (isInput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setFilter(ForgeDirection dir, FluidFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof EnderLiquidConduitNetwork)) {
            return false;
        }
        this.network = (EnderLiquidConduitNetwork)network;
        for (ForgeDirection dir : this.externalConnections) {
            this.network.connectionChanged(this, dir);
        }
        return true;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return ICONS.get(ICON_KEY);
    }

    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_EXTRACT_KEY);
    }

    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_INSERT_KEY);
    }

    public IIcon getTextureForInOutMode() {
        return ICONS.get(ICON_IN_OUT_KEY);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        return con instanceof EnderLiquidConduit;
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnections(dir);
    }

    private void refreshConnections(ForgeDirection dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
    }

    @Override
    public boolean isExtractingFromDir(ForgeDirection dir) {
        return this.getConnectionMode(dir).acceptsInput();
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.hasConnectionMode(ConnectionMode.INPUT) && !this.hasConnectionMode(ConnectionMode.IN_OUT)) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (ForgeDirection dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        return this.network.fillFrom(this, from, resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.network == null) {
            return new FluidTankInfo[0];
        }
        return this.network.getTankInfo(this, from);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        FluidFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isEmpty()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isEmpty()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            FluidFilter f;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                f = new FluidFilter();
                f.readFromNBT(filterTag);
                if (!f.isEmpty()) {
                    this.inputFilters.put(dir, f);
                }
            }
            if (!nbtRoot.func_74764_b(key = "outFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
            f = new FluidFilter();
            f.readFromNBT(filterTag);
            if (f.isEmpty()) continue;
            this.outputFilters.put(dir, f);
        }
    }
}

