/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class ExistingItemFilter
implements IItemFilter {
    boolean matchMeta = true;
    boolean useOreDict = false;
    boolean convertOreDict = false;
    boolean matchNBT = false;
    boolean sticky = false;
    List<ItemStack> snapshot = null;

    @Override
    public boolean doesItemPassFilter(NetworkedInventory ni, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.snapshot == null) {
            int[] slots = ni.getInventory().func_94128_d(ni.getInventorySide());
            for (int i = 0; i < slots.length; ++i) {
                ItemStack stack = ni.getInventory().func_70301_a(i);
                if (!this.stackEqual(item, stack)) continue;
                return true;
            }
        } else {
            for (ItemStack stack : this.snapshot) {
                if (!this.stackEqual(item, stack)) continue;
                return true;
            }
        }
        return false;
    }

    boolean stackEqual(ItemStack toInsert, ItemStack existing) {
        if (toInsert == null || existing == null) {
            return false;
        }
        boolean matched = false;
        if (this.useOreDict) {
            int existingId = OreDictionary.getOreID((ItemStack)existing);
            boolean bl = matched = existingId != -1 && existingId == OreDictionary.getOreID((ItemStack)toInsert);
        }
        if (!matched) {
            boolean bl = matched = Item.func_150891_b((Item)toInsert.func_77973_b()) == Item.func_150891_b((Item)existing.func_77973_b());
            if (matched && this.matchMeta) {
                boolean bl2 = matched = toInsert.func_77960_j() == existing.func_77960_j();
            }
            if (matched && this.matchNBT) {
                matched = ItemStack.func_77970_a((ItemStack)toInsert, (ItemStack)existing);
            }
        }
        return matched;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        boolean res = this.sticky && this.doesItemPassFilter(inv, item);
        return res;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<Slot> getSlots(int xOffset, int yOffset) {
        return Collections.emptyList();
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public void setSnapshot(NetworkedInventory ni) {
        this.snapshot = new ArrayList<ItemStack>();
        int[] slots = ni.getInventory().func_94128_d(ni.getInventorySide());
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = ni.getInventory().func_70301_a(i);
            if (stack == null) continue;
            this.snapshot.add(stack);
        }
    }

    public List<ItemStack> getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(List<ItemStack> snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
        if (nbtRoot.func_74764_b("snapshot")) {
            this.snapshot = new ArrayList<ItemStack>();
            NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("snapshot");
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemList.func_150305_b(i);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
                if (itemStack == null) continue;
                this.snapshot.add(itemStack);
            }
        } else {
            this.snapshot = null;
        }
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.matchMeta = nbtRoot.func_74767_n("matchMeta");
        this.matchNBT = nbtRoot.func_74767_n("matchNBT");
        this.useOreDict = nbtRoot.func_74767_n("useOreDict");
        this.sticky = nbtRoot.func_74767_n("sticky");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
        if (this.snapshot != null) {
            NBTTagList itemList = new NBTTagList();
            int i = 0;
            for (ItemStack item : this.snapshot) {
                if (item != null) {
                    NBTTagCompound itemTag = new NBTTagCompound();
                    item.func_77955_b(itemTag);
                    itemList.func_74742_a((NBTBase)itemTag);
                }
                ++i;
            }
            nbtRoot.func_74782_a("snapshot", (NBTBase)itemList);
        }
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("matchMeta", this.matchMeta);
        nbtRoot.func_74757_a("matchNBT", this.matchNBT);
        nbtRoot.func_74757_a("useOreDict", this.useOreDict);
        nbtRoot.func_74757_a("sticky", this.sticky);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound(settingsTag, buf);
        buf.writeInt(this.snapshot == null ? 0 : this.snapshot.size());
        if (this.snapshot == null) {
            return;
        }
        for (ItemStack item : this.snapshot) {
            NBTTagCompound itemRoot = new NBTTagCompound();
            item.func_77955_b(itemRoot);
            NetworkUtil.writeNBTTagCompound(itemRoot, buf);
        }
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound(buf);
        this.readSettingsFromNBT(settingsTag);
        int numItems = buf.readInt();
        if (numItems == 0) {
            this.snapshot = null;
            return;
        }
        this.snapshot = new ArrayList<ItemStack>(numItems);
        for (int i = 0; i < numItems; ++i) {
            NBTTagCompound itemTag = NetworkUtil.readNBTTagCompound(buf);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            if (item == null) continue;
            this.snapshot.add(item);
        }
    }
}

