/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ModItemFilter;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ModItemFilterGui
implements IItemFilterGui {
    private IItemConduit itemConduit;
    private GuiExternalConnection gui;
    boolean isInput;
    private ModItemFilter filter;
    private Rectangle[] inputBounds;
    private IconButtonEIO[] deleteButs;
    private int inputOffsetX;
    private int tfWidth;

    public ModItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        if (isInput) {
            this.filter = (ModItemFilter)itemConduit.getInputFilter(gui.getDir());
            this.inputOffsetX = 50;
            this.tfWidth = 86;
        } else {
            this.filter = (ModItemFilter)itemConduit.getOutputFilter(gui.getDir());
            this.inputOffsetX = 32;
            this.tfWidth = 104;
        }
        this.inputBounds = new Rectangle[]{new Rectangle(this.inputOffsetX, 48, 16, 16), new Rectangle(this.inputOffsetX, 69, 16, 16), new Rectangle(this.inputOffsetX, 90, 16, 16)};
        this.deleteButs = new IconButtonEIO[this.inputBounds.length];
        for (int i = 0; i < this.deleteButs.length; ++i) {
            IconButtonEIO but;
            Rectangle r = this.inputBounds[i];
            this.deleteButs[i] = but = new IconButtonEIO(gui, GuiExternalConnection.nextButtonId(), r.x + 19, r.y, IconEIO.MINUS);
        }
    }

    @Override
    public void deactivate() {
        for (IconButtonEIO but : this.deleteButs) {
            but.detach();
        }
    }

    @Override
    public void updateButtons() {
        for (IconButtonEIO but : this.deleteButs) {
            but.onGuiInit();
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        for (int i = 0; i < this.deleteButs.length; ++i) {
            IconButtonEIO but = this.deleteButs[i];
            if (but.field_146127_k != guiButton.field_146127_k) continue;
            this.setMod(i, null);
            return;
        }
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/externalConduitConnection.png");
        for (Rectangle r : this.inputBounds) {
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x - 1, this.gui.getGuiTop() + r.y - 1, 24, 238, 18, 18);
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x + 38, this.gui.getGuiTop() + r.y - 1, 24, 238, 4, 18);
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x + 42, this.gui.getGuiTop() + r.y - 1, 120, 238, this.tfWidth, 18);
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x + 42 + this.tfWidth, this.gui.getGuiTop() + r.y - 1, 38, 238, 4, 18);
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.inputBounds.length; ++i) {
            Rectangle r;
            String mod = this.filter.getModAt(i);
            if (mod == null) continue;
            r = this.inputBounds[i];
            fr.func_78261_a(mod, this.gui.getGuiLeft() + r.x + 41, this.gui.getGuiTop() + r.y + 4, ColorUtil.getRGB(Color.white));
        }
        RenderUtil.bindTexture("enderio:textures/gui/externalConduitConnection.png");
        int edge = this.inputBounds[0].x + this.tfWidth + 46;
        this.gui.func_73729_b(this.gui.getGuiLeft() + edge, this.gui.getGuiTop() + this.inputBounds[0].y, edge, 20, 30, 60);
        for (Rectangle r : this.inputBounds) {
            this.gui.func_73729_b(this.gui.getGuiLeft() + edge - 1, this.gui.getGuiTop() + r.y - 1, 41, 238, 1, 18);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        ItemStack st = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (st == null) {
            return;
        }
        for (int i = 0; i < this.inputBounds.length; ++i) {
            Rectangle bound = this.inputBounds[i];
            if (!bound.contains(x, y)) continue;
            this.setMod(i, st);
        }
    }

    private void setMod(int i, ItemStack st) {
        String mod = this.filter.setMod(i, st);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketModItemFilter(this.itemConduit, this.gui.getDir(), this.isInput, i, mod));
    }
}

