/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.item.InventoryFilterUpgrade;
import crazypants.enderio.conduit.gui.item.InventorySpeedUpgrades;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ExternalConnectionContainer
extends Container {
    private InventoryPlayer playerInv;
    private IConduitBundle bundle;
    private ForgeDirection dir;
    private IItemConduit itemConduit;
    private IItemFilter inputFilter;
    private IItemFilter outputFilter;
    private int outputFilterUpgradeSlot = 36;
    private int inputFilterUpgradeSlot = 37;
    private int speedUpgradeSlot = 38;
    private int startFilterSlot = 39;
    private List<Point> slotLocations = new ArrayList<Point>();
    List<FilterChangeListener> filterListeners = new ArrayList<FilterChangeListener>();

    public ExternalConnectionContainer(InventoryPlayer playerInv, IConduitBundle bundle, ForgeDirection dir) {
        int y;
        int x;
        int i;
        this.playerInv = playerInv;
        this.bundle = bundle;
        this.dir = dir;
        int topY = 113;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                x = 23 + j * 18;
                y = topY + i * 18;
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, x, y));
                this.slotLocations.add(new Point(x, y));
            }
        }
        y = 171;
        for (i = 0; i < 9; ++i) {
            x = 23 + i * 18;
            this.func_75146_a(new Slot((IInventory)playerInv, i, x, y));
            this.slotLocations.add(new Point(x, y));
        }
        this.itemConduit = bundle.getConduit(IItemConduit.class);
        if (this.itemConduit != null) {
            x = 10;
            y = 47;
            InventoryFilterUpgrade fi = new InventoryFilterUpgrade(this.itemConduit, dir, false);
            this.func_75146_a(new FilterSlot(fi, 0, x, y, false));
            this.slotLocations.add(new Point(x, y));
            x = 10;
            y = 47;
            fi = new InventoryFilterUpgrade(this.itemConduit, dir, true);
            this.func_75146_a(new FilterSlot(fi, 0, x, y, true));
            this.slotLocations.add(new Point(x, y));
            x = 28;
            y = 47;
            final InventorySpeedUpgrades si = new InventorySpeedUpgrades(this.itemConduit, dir);
            this.func_75146_a(new Slot(si, 0, x, y){

                public boolean func_75214_a(ItemStack par1ItemStack) {
                    return si.func_94041_b(0, par1ItemStack);
                }
            });
            this.slotLocations.add(new Point(x, y));
            this.addFilterSlots(dir);
        }
    }

    public void addFilterListener(FilterChangeListener list) {
        this.filterListeners.add(list);
    }

    private void addFilterSlots(ForgeDirection dir) {
        List<Slot> slots;
        this.inputFilter = this.itemConduit.getInputFilter(dir);
        if (this.inputFilter != null && this.inputFilter.getSlotCount() > 0) {
            slots = this.inputFilter.getSlots(33, 69);
            for (Slot slot : slots) {
                this.func_75146_a(slot);
                this.slotLocations.add(new Point(slot.field_75223_e, slot.field_75221_f));
            }
        }
        this.outputFilter = this.itemConduit.getOutputFilter(dir);
        if (this.outputFilter != null && this.outputFilter.getSlotCount() > 0) {
            slots = this.outputFilter.getSlots(33, 69);
            for (Slot slot : slots) {
                this.func_75146_a(slot);
                this.slotLocations.add(new Point(slot.field_75223_e, slot.field_75221_f));
            }
        }
    }

    protected void filterChanged() {
        int slotsToRemove = this.field_75151_b.size() - this.startFilterSlot;
        for (int i = 0; i < slotsToRemove; ++i) {
            int removeIndex = this.field_75151_b.size() - 1;
            this.field_75151_b.remove(removeIndex);
            this.field_75153_a.remove(removeIndex);
            this.slotLocations.remove(removeIndex);
        }
        this.addFilterSlots(this.dir);
        for (FilterChangeListener list : this.filterListeners) {
            list.onFilterChanged();
        }
    }

    public void setInputSlotsVisible(boolean visible) {
        if (this.itemConduit == null) {
            return;
        }
        this.setSlotsVisible(visible, this.inputFilterUpgradeSlot, this.inputFilterUpgradeSlot + 1);
        this.setSlotsVisible(visible, this.speedUpgradeSlot, this.speedUpgradeSlot + 1);
        if (this.inputFilter == null || this.inputFilter.getSlotCount() == 0) {
            return;
        }
        int startIndex = this.startFilterSlot;
        int endIndex = this.inputFilter.getSlotCount() + startIndex;
        this.setSlotsVisible(visible, startIndex, endIndex);
    }

    public void setOutputSlotsVisible(boolean visible) {
        if (this.itemConduit == null) {
            return;
        }
        this.setSlotsVisible(visible, this.outputFilterUpgradeSlot, this.outputFilterUpgradeSlot + 1);
        if (this.outputFilter == null || this.outputFilter.getSlotCount() == 0) {
            return;
        }
        int startIndex = this.startFilterSlot + (this.inputFilter == null ? 0 : this.inputFilter.getSlotCount());
        int endIndex = startIndex + this.outputFilter.getSlotCount();
        this.setSlotsVisible(visible, startIndex, endIndex);
    }

    public void setInventorySlotsVisible(boolean visible) {
        this.setSlotsVisible(visible, 0, 36);
    }

    private void setSlotsVisible(boolean visible, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            Slot s = (Slot)this.field_75151_b.get(i);
            if (visible) {
                s.field_75223_e = this.slotLocations.get((int)i).x;
                s.field_75221_f = this.slotLocations.get((int)i).y;
                continue;
            }
            s.field_75223_e = -3000;
            s.field_75221_f = -3000;
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack func_75144_a(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        if (par4EntityPlayer.field_70170_p != null && par1 >= this.startFilterSlot && this.itemConduit != null) {
            this.itemConduit.setInputFilter(this.dir, this.inputFilter);
            this.itemConduit.setOutputFilter(this.dir, this.outputFilter);
        }
        try {
            return super.func_75144_a(par1, par2, par3, par4EntityPlayer);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        return null;
    }

    private class FilterSlot
    extends Slot {
        boolean isInput;

        public FilterSlot(IInventory par1iInventory, int par2, int par3, int par4, boolean isInput) {
            super(par1iInventory, par2, par3, par4);
            this.isInput = isInput;
        }

        public void func_75218_e() {
            ExternalConnectionContainer.this.filterChanged();
        }

        public boolean func_75214_a(ItemStack par1ItemStack) {
            return this.field_75224_c.func_94041_b(0, par1ItemStack);
        }
    }
}

