/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.render.BoundingBox;
import crazypants.render.RenderUtil;
import crazypants.render.VertexRotation;
import crazypants.render.VertexTransform;
import crazypants.render.VertexTransformComposite;
import crazypants.render.VertexTranslation;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectionModeGeometry {
    private static final EnumMap<ForgeDirection, List<Vertex>> VERTS = new EnumMap(ForgeDirection.class);

    private static List<Vertex> createVerticesForDir(BoundingBox refBB, VertexTransform xform) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(24);
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            result.addAll(refBB.getCornersWithUvForFace(face));
        }
        for (Vertex v : result) {
            xform.apply(v.xyz);
            xform.applyToNormal(v.normal);
        }
        return result;
    }

    public static void renderModeConnector(ForgeDirection dir, Offset offset, IIcon tex, boolean tintSides) {
        List<Vertex> verts = VERTS.get(dir);
        if (verts == null) {
            return;
        }
        Vector3d trans = ConduitGeometryUtil.instance.getTranslation(dir, offset);
        float uWidth = tex.func_94212_f() - tex.func_94209_e();
        float uScale = uWidth * 0.64f;
        float minU = tex.func_94209_e() + (uWidth - uScale);
        float vScale = tex.func_94210_h() - tex.func_94206_g();
        Tessellator tes = Tessellator.field_78398_a;
        for (Vertex v : verts) {
            if (tintSides) {
                float cm = 1.0f;
                if ((double)v.ny() > 0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.UP);
                } else if ((double)v.ny() < -0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.DOWN);
                } else if ((double)v.nx() > 0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.EAST);
                } else if ((double)v.nx() < -0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.WEST);
                } else if ((double)v.nz() > 0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.SOUTH);
                } else if ((double)v.nz() < -0.1) {
                    cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.NORTH);
                }
                tes.func_78386_a(cm, cm, cm);
            }
            tes.func_78375_b(v.nx(), v.ny(), v.nz());
            tes.func_78374_a(v.x() + trans.x, v.y() + trans.y, v.z() + trans.z, (double)(minU + v.u() * uScale), (double)(tex.func_94206_g() + v.v() * vScale));
        }
    }

    static {
        float scale = 0.9f;
        BoundingBox refBB = ConduitGeometryUtil.CORE_BOUNDS;
        refBB = refBB.scale(scale, scale, scale);
        refBB = refBB.scale(scale, 1.0f, 1.0f);
        double offset = ConduitGeometryUtil.HWIDTH * scale * scale + 0.05f;
        VertexRotation vrot = new VertexRotation(1.5707963267948966, new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.5, 0.5));
        VertexTranslation vtrans = new VertexTranslation(0.0f, 0.0f, 0.0f);
        VertexTransformComposite xform = new VertexTransformComposite(vrot, vtrans);
        ForgeDirection dir = ForgeDirection.SOUTH;
        Vector3d trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.NORTH;
        vrot.setAngle(4.71238898038469);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.EAST;
        vrot.setAngle(Math.PI);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.WEST;
        vrot.setAngle(0.0);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
        vrot.setAxis(new Vector3d(0.0, 0.0, 1.0));
        dir = ForgeDirection.UP;
        vrot.setAngle(-1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.DOWN;
        vrot.setAngle(1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, xform));
    }
}

